% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lawn_bbox.R
\name{lawn_bbox}
\alias{lawn_bbox}
\title{Make a bounding box from a polygon}
\usage{
lawn_bbox(x, lint = FALSE)
}
\arguments{
\item{x}{A FeatureCollection of \link{data-Polygon} features.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
A bounding box.
}
\description{
Takes a polygon \link{data-Polygon} and returns a bbox
}
\examples{
bbox <- c(0, 0, 10, 10)
lawn_bbox(lawn_bbox_polygon(bbox))
}
\seealso{
Other measurements: \code{\link{lawn_along}},
  \code{\link{lawn_area}}, \code{\link{lawn_bbox_polygon}},
  \code{\link{lawn_bearing}},
  \code{\link{lawn_center_of_mass}},
  \code{\link{lawn_center}}, \code{\link{lawn_centroid}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_extent}},
  \code{\link{lawn_line_distance}},
  \code{\link{lawn_midpoint}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_pt2line_distance}},
  \code{\link{lawn_square}}
}
