% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getcoord.R
\name{lawn_getcoord}
\alias{lawn_getcoord}
\title{Unwrap a coordinate from a Feature with a Point geometry,
or a single coordinate.}
\usage{
lawn_getcoord(x, lint = FALSE)
}
\arguments{
\item{x}{any \link{data-GeoJSON} object}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
matrix of coordinates, where each row in the matrix is a
coordinate pair
}
\description{
Unwrap a coordinate from a Feature with a Point geometry,
or a single coordinate.
}
\examples{
x <- "{ type: 'Point', coordinates: [10, 50] }"
lawn_getcoord(x)

library(jsonlite)
x <- fromJSON(lawn_data$points_count, FALSE)$features
lawn_getcoord(x[[1]])
lawn_getcoord(x[[2]])
lawn_getcoord(x[[1]]$geometry)
lawn_getcoord(x[[1]]$geometry$coordinates)

# fails
# lawn_getcoord(x[[1]]$geometry$coordinates[[1]])
}
