% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify.R
\name{lawn_simplify}
\alias{lawn_simplify}
\title{Simplify GeoJSON data}
\usage{
lawn_simplify(
  feature,
  tolerance = 0.01,
  high_quality = FALSE,
  mutate = FALSE,
  lint = FALSE
)
}
\arguments{
\item{feature}{A \link{data-Feature}<(\link{data-LineString}, \link{data-Polygon},
\link{data-MultiLineString}, \link{data-MultiPolygon})>, or \link{data-FeatureCollection},
or \link{data-GeometryCollection}}

\item{tolerance}{(numeric) Simplification tolerance.  Default value is 0.01.}

\item{high_quality}{(boolean) Whether or not to spend more time to create a
higher-quality simplification with a different algorithm. Default: \code{FALSE}}

\item{mutate}{(boolean) allows GeoJSON input to be mutated (significant
performance increase if \code{TRUE}). Default: \code{FALSE}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
A simplified feature.

A Feature of either \link{data-Polygon} or \link{data-LineString}.
}
\description{
Takes a \link{data-LineString} or \link{data-Polygon}
and returns a simplified version.
}
\details{
Internally uses simplify-js
to perform simplification.
}
\examples{
feature <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [-70.603637, -33.399918],
      [-70.614624, -33.395332],
      [-70.639343, -33.392466],
      [-70.659942, -33.394759],
      [-70.683975, -33.404504],
      [-70.697021, -33.419406],
      [-70.701141, -33.434306],
      [-70.700454, -33.446339],
      [-70.694274, -33.458369],
      [-70.682601, -33.465816],
      [-70.668869, -33.472117],
      [-70.646209, -33.473835],
      [-70.624923, -33.472117],
      [-70.609817, -33.468107],
      [-70.595397, -33.458369],
      [-70.587158, -33.442901],
      [-70.587158, -33.426283],
      [-70.590591, -33.414248],
      [-70.594711, -33.406224],
      [-70.603637, -33.399918]
    ]]
  }
}'

lawn_simplify(feature, tolerance = 0.01)
\dontrun{
lawn_simplify(feature, tolerance = 0.01) \%>\% view
}
}
\seealso{
Other transformations: 
\code{\link{lawn_bezier}()},
\code{\link{lawn_buffer}()},
\code{\link{lawn_concave}()},
\code{\link{lawn_convex}()},
\code{\link{lawn_difference}()},
\code{\link{lawn_intersect}()},
\code{\link{lawn_merge}()},
\code{\link{lawn_union}()}
}
\concept{transformations}
