% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyraster.R
\name{lazyraster}
\alias{lazyraster}
\title{Lazy raster}
\usage{
lazyraster(gdalsource, band = 1, sds = NULL, ...)
}
\arguments{
\item{gdalsource}{a file name or other source string}

\item{band}{which band to use, defaults to 1}

\item{sds}{which subdataset to use, set to 1 if in doubt (see \code{vapour::vapour_sds_names})}

\item{...}{ignored for now}
}
\value{
a lazyraster object, a simple shell around a GDAL raster source
}
\description{
A lazyraster is a metadata-only shell around a raster file source. Only metadata is read
and and used for extent and resolution logic. A lazyraster may be cropped lazily
and if plotted or converted to in-memory raster only a reasonable level-of-detail is actually
used.
}
\details{
See \code{\link[=crop]{crop()}} for cropping - it works the same but returns a lazyraster,
and \code{\link[=as_raster]{as_raster()}} for converting to an in-memory raster.
}
\section{Warning}{

If the inferred Y extents appear to be reversed (ymax > ymin) then they are
reversed, with a warning. This occurs for any GDAL data source that does not have
a geotransform and so is required for use with raster. This might not be the right interpretation,
geotransforms are very general and it might mean the data is meant to be oriented that way.
(I don't know why GDAL sets a positive Y pixel height as the default, it's a bit of a pain -
should the data be flipped, or should Y be interpreted negative - no way to know!).
}

\examples{
sstfile <- system.file("extdata/sst.tif", package = "vapour")
lazyraster(sstfile)
## convert to raster (in memory, but not all of the source)
as_raster(lazyraster(sstfile))
## crop and stay as lazyraster
crop(lazyraster(sstfile), raster::extent(142, 143, -50, -45))
## crop and convert to raster
as_raster(crop(lazyraster(sstfile), raster::extent(142, 143, -50, -45)))
}
