% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_record_policy.R
\name{rl_record_policy}
\alias{rl_record_policy}
\title{Record Reinforcement Learning Policy.}
\usage{
rl_record_policy(
  x,
  last_result,
  trading_system,
  path_terminal,
  fileName = "SystemControl"
)
}
\arguments{
\item{x}{- Dataframe containing columns MarketType and Policy}

\item{last_result}{- character vector of the last result of the trade}

\item{trading_system}{- character vector of length 1 with Trading System Magic Number information}

\item{path_terminal}{- path to the sandbox where this Policy/Decision must be written}

\item{fileName}{- string, desired control file prefix e.g. 'SystemControl'}
}
\value{
nothing is returned but function will write csv file to the supplied directory
}
\description{
Function will write a policy 'decision' to the csv file specific for each Expert Advisor
}
\examples{


library(stringr)
library(magrittr)
library(dplyr)
data(TradeStatePolicy)

dir <- normalizePath(tempdir(),winslash = "/")

rl_record_policy(x = TradeStatePolicy,
              last_result = "tradewin",
              trading_system = 8118101,
              path_terminal = dir,
              fileName = "SystemControlRL")



}
\author{
(C) 2019,2021 Vladimir Zhbanko
}
