% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_record_policy_mt.R
\name{rl_record_policy_mt}
\alias{rl_record_policy_mt}
\title{Record Reinforcement Learning Policy for Market Types}
\usage{
rl_record_policy_mt(
  x,
  trading_system,
  path_terminal,
  fileName = "SystemControlMT"
)
}
\arguments{
\item{x}{- Dataframe containing columns MarketType and Policy}

\item{trading_system}{- numeric vector of length 1 with Trading System Magic Number information}

\item{path_terminal}{- string, path to the terminal where this Policy/Decision must be written}

\item{fileName}{- string, desired control file prefix e.g. 'SystemControlMT'}
}
\value{
nothing is returned but function will write csv file to the supplied directory
}
\description{
Function will write a policy 'decision' to the csv file specific for each Expert Advisor
}
\examples{


library(stringr)
library(lazytrade)
data(policy_tr_systDF)

dir <- normalizePath(tempdir(),winslash = "/")

rl_record_policy_mt(x = policy_tr_systDF,
                 trading_system = 8118101,
                 path_terminal = dir,
                 fileName = "SystemControlMT")


}
