% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldamatch.R
\name{match_groups}
\alias{match_groups}
\title{Creates a matched group via backward selection.}
\usage{
match_groups(condition, covariates, halting_test, thresh = 0.2,
  method = c("heuristic1", "random", "heuristic2", "heuristic3", "heuristic4",
  "exhaustive"), props = prop.table(table(condition)), replicates = NULL,
  min_preserved = NULL, print_info = get("PRINT_INFO", .ldamatch_globals),
  max_removed = NULL, tiebreaker = NULL, lookahead = NULL,
  all_results = FALSE)
}
\arguments{
\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A columnwise matrix containing
covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
which is TRUE iff the conditions are matched.
Signature: halting_test(condition, covariates, thresh).
The following halting tests are part of this package:
\code{\link{t_halt}}, \code{\link{U_halt}},
\code{\link{l_halt}}, \code{\link{ad_halt}},
\code{\link{ks_halt}}, \code{\link{wilks_halt}},
\code{\link{f_halt}}.
You can create the intersection of two or more halting
tests using \code{\link{create_halting_test}}.}

\item{thresh}{The return value of halting_test has to be greater than
or equal to thresh for the matched groups.}

\item{method}{The choice of search method, one of "heuristic1"
(formerly called "heuristic"), "random", "heuristic2",
"heuristic3", "heuristic4", and "exhaustive".
The running time increases approximately in the above
order.
You can get more information about each method on the
help page for "search_<method_name>"
(e.g. "\code{\link{search_exhaustive}}").}

\item{props}{Either the desired proportions (percentage) of the
sample for each condition as a named vector,
or the names of the conditions
for which we prefer to preserve the subjects,
in decreasing order of preference. If not specified, the
(full) sample proportions are used.
This is enforced by the "heuristic1" method,
preferred among configurations with the same number of
total subjects by the "exhaustive" method, and
taken into account by the other methods to some extent.
For example, c(A = 0.4, B = 0.4, C = 0.2) means that
we would like the number of subjects in groups A, B, and
C to be around 40\%, 40\%, and 20\% of the total number of
subjects, respectively. Whereas c("A", "B", "C") means
that if possible, we would like to keep all subjects
in group A, and prefer keeping subjects in B, even if
it results in losing more subjects from C.}

\item{replicates}{The maximum number of random replications to be
performed. This is only used for the "random"
method.}

\item{min_preserved}{The minimum number of preserved subjects.
It can be used to ensure that the search will not take
forever to run, but instead fail when a solution is not
found when preserving this number of subjects.}

\item{print_info}{If TRUE, prints summary information on the input and the
results, as well as progress information for the
exhaustive search and random algorithms. Default: TRUE;
can be changed using
\code{\link{set_param}("PRINT_INFO", FALSE)}.}

\item{max_removed}{A named integer vector, containing the maximum number
of subjects that can be removed from each group.
Specify 0 for groups if you want to preserve
all of their subjects. If you do not specify a value
for a group, it defaults to one less than the group size.
Values outside the valid range of 0..(N-1)
(where N is the number of subjects in the group)
are corrected without a warning.}

\item{tiebreaker}{NULL, or a function similar to halting_test, used to
decide between cases for which halting_test yields
equal values.}

\item{lookahead}{The lookahead to use: a positive integer.
it is used by the heuristic3 and heuristic4 algorithms,
with a default of 2. As you increase it,
the running time increases exponentially.}

\item{all_results}{If TRUE, returns all results found by method in a list.
(A list is returned even if there is only one result.)
If FALSE (the default), it returns the first result
(a logical vector).}
}
\value{
A logical vector that contains TRUE for the conditions
                     that are in the matched groups;
                     or if all_results = TRUE, a list of such vectors.
}
\description{
Creates a matched group via backward selection.
}
\details{
The exhaustive, heuristic3, and heuristic4 search methods use the foreach
package to parallelize computation.
To take advantage of this, you must register a cluster.
For example, to use all but one of the CPU cores, run:
  \code{doMC::registerDoMC(max(1, parallel::detectCores() - 1))}
To use sequential processing without getting a warning, run:
  \code{foreach::registerDoSEQ()}
}
\seealso{
\code{\link{calc_p_value}} for calculating the test statistic for
a group setup.

\code{\link{calc_metrics}} for calculating multiple metrics about
the goodness of the result.

\code{\link{compare_ldamatch_outputs}} for comparing multiple
different results from this function.
}

