% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{slcor}
\alias{slcor}
\title{Sliding window correlation}
\usage{
slcor(x, win = 1L)
}
\arguments{
\item{x}{A numeric matrix. The variables index the columns.}

\item{win}{The size of the window. Defaults to 1.}
}
\value{
A correlation matrix with only the observations within a window
containing calculated correlations.
}
\description{
Calculates the pairwise Pearson correlation between all columns
within a fixed window size (\code{win})
using the \code{use = "pairwise.complete.obs"} option
from \code{\link[stats]{cor}()}. That is, the correlation
between each pair of variables is computed using all complete pairs
of observations on those variables.
}
\examples{
set.seed(1)
n <- 10
p <- 100
xmat <- matrix(rnorm(n * p), ncol = n)
xmat[sample(n * p, size = 30)] <- NA_real_
slcor(xmat, win = 2)

}
\author{
David Gerard
}
