% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{boxCoxTransform}
\alias{boxCoxTransform}
\title{Box-Cox Transformation of Numeric Matrix}
\usage{
boxCoxTransform(data, lambda, ...)
}
\arguments{
\item{data}{A numeric matrix to be transformed.}

\item{lambda}{A numeric vector, a single number, NA, or NULL indicating the lambda parameter(s) for the Box-Cox transformation.
Use \code{NULL} for no transformation, \code{NA} for estimating the lambda parameter for each variable,
a single number for equal lambda parameter for all variables, and a numeric vector for distinct lambda parameters for the corresponding variables.}

\item{...}{additional parameters for \code{MASS::boxcox} function.}
}
\value{
\item{data}{transformed data}
\item{lambda}{final lambda vector used in the calculations.}
}
\description{
This function applies the Box-Cox transformation to the columns of a numeric matrix.
}
\examples{
data <- matrix(rnorm(40), ncol = 2)
result <- ldt:::boxCoxTransform(data, c(0.5, 0.5))

}
