% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapkeyIcon.R
\name{makeMapkeyIcon}
\alias{makeMapkeyIcon}
\title{Make Mapkey Icon}
\usage{
makeMapkeyIcon(
  icon = "mapkey",
  color = "#ff0000",
  iconSize = 12,
  background = "#1F7499",
  borderRadius = "100\%",
  hoverScale = 1.4,
  hoverEffect = TRUE,
  additionalCSS = NULL,
  hoverCSS = NULL,
  htmlCode = NULL,
  boxShadow = TRUE
)
}
\arguments{
\item{icon}{ID of the mapkey Icon you want to use.}

\item{color}{Any CSS color (e.g. 'red','rgba(20,160,90,0.5)', '#686868', ...)}

\item{iconSize}{Size of Icon in Pixels. Default is 12}

\item{background}{Any CSS color or false for no background}

\item{borderRadius}{Any number (for circle size/2, for square 0.001)}

\item{hoverScale}{Any real number (best result in range 1 - 2, use 1 for no
effect)}

\item{hoverEffect}{Switch on/off effect on hover}

\item{additionalCSS}{CSS code (e.g. \code{"border:4px solid #aa3838;"})}

\item{hoverCSS}{CSS code (e.g. \code{"background-color:#992b00 !important;
color:#99defc !important;"})}

\item{htmlCode}{e.g. \code{'&#57347;&#xe003;'}.}

\item{boxShadow}{Should a shadow be visible}
}
\value{
A list of mapkey-icon data that can be passed to the argument \code{icon}
}
\description{
Make Mapkey Icon
}
\examples{
makeMapkeyIcon(icon = "traffic_signal",
               color = "#0000ff",
               iconSize = 12,
               boxShadow = FALSE,
               background="transparent")
}
\references{
\url{https://github.com/mapshakers/leaflet-mapkey-icon}
}
\seealso{
Other Mapkey Functions: 
\code{\link{[.leaflet_mapkey_icon_set}()},
\code{\link{addMapkeyMarkers}()},
\code{\link{mapkeyIconList}()},
\code{\link{mapkeyIcons}()}
}
\concept{Mapkey Functions}
