% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_current_providers.R
\name{use_providers}
\alias{use_providers}
\title{Use custom tile provider}
\usage{
use_providers(providers_info = NULL)
}
\arguments{
\item{providers_info}{A custom \code{leaflet_providers} object.
If \code{NULL}, uses default providers.}
}
\description{
Use a custom \code{leaflet_providers} object, e.g. providers data fetched with
\link{get_providers}, with the \code{leaflet} package.
}
\examples{
\donttest{
if (require("V8") && require("jsonlite")) {
  # Set providers to latest providers
  use_providers(get_providers())

  # Set providers to a custom providers object (specific version number)
  use_providers(get_providers("1.4.0"))
  use_providers("1.4.0")
}
}
}
