% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matrix_interp}
\alias{matrix_interp}
\title{Arranges Matrix Elements in Order of Magnitude for Interpretation}
\usage{
matrix_interp(object, mat_chosen = 1L, part = 1L, type = 3L)
}
\arguments{
\item{object}{A list object in one of \code{lefko3}'s output formats. These
may include \code{lefkoMat}, \code{lefkoSens}, \code{lefkoElas}, and
\code{lefkoLTRE} objects.}

\item{mat_chosen}{The number of the matrix to assess, within the appropriate
matrix list. See \code{Notes} for further details.}

\item{part}{An integer noting whether to provide assessments of which of the
main types of matrices to analyze. In a standard \code{lefkoMat} object, the
integers \code{1}, \code{2}, and \code{3} correspond to the \code{A},
\code{U}, and \code{F} lists, respectively. In \code{lefkoSens} and
\code{lefkoElas} objects, the integers \code{1} and \code{2} correspond to
the ahistorical matrix sets and the historical matrix sets, respectively.
In deterministic and stochastic \code{lefkoLTRE} objects, the integers
\code{1} and \code{2} correspond to the \code{cont_mean} and \code{cont_sd}
lists, respectively.}

\item{type}{An integer corresponding to the type of order summary, including
most to least positive (\code{1}), most to least negative (\code{2}), and
greatest to lowest absolute magnitude (\code{3}). Defaults to type \code{3}.}
}
\value{
A data frame arranging all elements in the matrix chosen from
greatest and smallest. This can be a data frame of only positive elements,
of only negative elements, or all elements in order of absolute magnitude.
}
\description{
Function \code{matrix_interp} summarizes matrices from \code{lefkoMat},
\code{lefkoSens}, \code{lefkoElas}, and \code{lefkoLTRE} objects in terms
of the magnitudes of their elements.
}
\section{Notes}{

This will be the number of the matrix within the list that it is held in.
For example, if the function is applied to the \code{cont_sd} portion of
a stochastic LTRE, and there are four LTRE matrices within that list element
corresponding to three patch LTRE matrices and one overall population-level
LTRE matrix, then setting this value to \code{4} would focus the function on
the overall population-level LTRE matrix associated with contributions of
the standard deviations of elements.

Huge sparse matrices may take more time to process than small, dense
matrices.
}

\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

aaa <- ltre3(cypmatrix2r, stochastic = TRUE)

matrix_interp(aaa, mat_chosen = 1, part = 2, type = 3)

}
