\name{powercurve.t.test}
\alias{powercurve.t.test}

\title{Compute a Power Curve with Colors}

\description{
From one or two sample sizes, and either the within-cell (pooled) standard deviation, or one or two separate group standard deviations, generate and calibrate a power curve for either the one-sample t-test or the independent-groups t-test, as well as ancillary statistics.  Uses the standard R function \code{power.t.test} to calculate power and then the \code{\link{color.plot}} function in this package to automatically display the annotated power curve with colors.

For both the one and two-group t-tests, power is calculated from a single sample size and single standard deviation. For the two-sample test, the within-group standard deviation is automatically calculated from the two separate group standard deviations if not provided directly. Similarly, the harmonic mean of two separate sample sizes is calculated if two separate sample sizes are provided.
}

\usage{
powercurve.t.test(n=NULL, s=NULL, n1=NULL, n2=NULL, s1=NULL, s2=NULL, 
                  mmd=NULL, msmd=NULL, mdp=.8, mu0=NULL, \dots)
}


\arguments{
  \item{n}{Sample size for each of the two groups.}
  \item{s}{Within-group, or pooled, standard deviation.}
  \item{n1}{Sample size for Group 1.}
  \item{n2}{Sample size for Group 2.}
  \item{s1}{Sample standard deviation for Group 1.}
  \item{s2}{Sample standard deviation for Group 2.}
  \item{mmd}{Minimum Mean Difference of practical importance, the difference of the
       response variable between two group means. The concept is optional, and only one of \code{mmd} and \code{msmd} is provided.}
  \item{msmd}{For the Standardized Mean Difference, Cohen's \code{d}, the Minimum value of
       practical importance. The concept is optional, and only one of \code{mmd} and \code{msmd} is provided.}
  \item{mdp}{Minimum Desired Power, the smallest value of power considered to provide
       sufficient power. Default is 0.8. If changed to 0 then the concept is dropped from the analysis.}
  \item{mu0}{Hypothesized mean, of which a provided value triggers a one-sample 
       analysis.}
  \item{\dots}{Other parameter values, such as \code{lwd} and \code{cex.lab} from \code{\link{plot}}
        and \code{col.line} and \code{col.bg} from \code{\link{color.plot}}.}
}


\details{
This function relies upon the standard \code{\link{power.t.test}} function to calibrate and then calculate the power curve according to the relevant non-central t-distribution. The \code{\link{color.plot}} function from this package, which in turn relies upon the standard \code{\link{plot}} function, plots the power curve. As such, parameters in \code{\link{color.plot}} for controlling the different colors and other aspects of the display are also available, as are many of the more basic parameters in the usual \code{\link{plot}} function.

Also plotted, if provided, is the minimal meaningful difference, \code{mmd}, as well as the minimal desired power, \code{mdp}, provided by default.  Relevant calculations regarding these values are also displayed at the console.  One or both concepts can be deleted from the analysis.  Not providing a value \code{mmd} implies that the concept will not be considered, and similarly for setting \code{mdp} to 0.

Invoke the function with the either the within-group (pooled) standard deviation, \code{s}, or the two separate group standard deviations, \code{s1} and \code{s2}, from which \code{s} is computed.  If the separate standard deviations are provided, then also provide the sample sizes, either as a single value of \code{n} or as two separate sample sizes, \code{n1} and \code{n2}.  If separate sample sizes \code{n1} and \code{n2} are entered, their harmonic mean serves as the value of \code{n}.

For power analysis of the two-sample t-test, the null hypothesis is a zero population mean difference.  For a one-sample test, the null hypothesis is specified, and it is this non-null specification of mu0 that triggers the one-sample analysis. Only non-directional or two-tailed tests are analyzed.

The  effect size that achieves a power of 0.8 is displayed. If a minimal meaningful difference, \code{mmd}, is provided, then the  associated power is also displayed, as well as the needed sample size to achieve a power of 0.8.

If the function is called with no parameter values, that is, as \code{powercurve.t.test()}, then the values of \code{n1}, \code{n2} and sw must already exist before the function call.  If they do, these values are used in the power computations.  These three values can be set manually, or they are automatically computed and set by \code{\link{smd.t.test}}.
}

\author{David W. Gerbing (Portland State University; \email{davidg@sba.pdx.edu})}

\seealso{
\code{\link{color.plot}}, \code{\link{plot}}, \code{\link{power.t.test}}.
}
\examples{
# default power curve and colors
powercurve.t.test(n=20, s=5)

# default power curve and colors
# plus optional smallest meaningful effect to enhance the analysis
powercurve.t.test(n=20, s=5, mmd=2)

# power curve from both group standard deviations and sample sizes
# also provide the minimum standardized mean difference of 
#   practical importance to obtain corresponding power
powercurve.t.test(n1=15, n2=25, s1=4, s2=6, msmd=.5)
  
# power curve from both group standard deviations but common sample size
# color and display options from plot and color.plot functions
powercurve.t.test(n=20, s1=4, s2=6, lwd=2, col.line="darkred", 
  col.bg="moccasin", col.grid="lightsteelblue", mmd=2, mdp=.6)
  
# power curve for one sample t-test, triggered by non-null mu0
powercurve.t.test(n=20, s=5, mu0=30, mmd=2)

# power curve for previously specified values of n1, n2 and sw,
#  such as computed by smd.t.test, or specify manually, as done here
n1 <- 20;  n2 <- 25;  sw <- 5
powercurve.t.test()
}


% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ power }
\keyword{ t.test }
