% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlOptimizer.R
\name{controlIsta}
\alias{controlIsta}
\title{controlIsta}
\usage{
controlIsta(
  startingValues = "est",
  saveDetails = FALSE,
  L0 = 0.1,
  eta = 2,
  accelerate = TRUE,
  maxIterOut = 10000,
  maxIterIn = 1000,
  breakOuter = 1e-08,
  convCritInner = 1,
  sigma = 0.1,
  stepSizeInheritance = ifelse(accelerate, 1, 3),
  verbose = 0,
  nCores = 1
)
}
\arguments{
\item{startingValues}{option to provide initial starting values. Only used for the first lambda. Three options are supported. Setting to "est" will use the estimates
from the lavaan model object. Setting to "start" will use the starting values of the lavaan model. Finally, a labeled vector with parameter
values can be passed to the function which will then be used as starting values.}

\item{saveDetails}{when set to TRUE, additional details about the individual
models are save. Currently, this are the implied means and covariances.
Note: This may take a lot of memory!}

\item{L0}{L0 controls the step size used in the first iteration}

\item{eta}{eta controls by how much the step size changes in the
inner iterations with (eta^i)*L, where i is the inner iteration}

\item{accelerate}{boolean: Should the acceleration outlined in
Parikh, N., & Boyd, S. (2013). Proximal Algorithms. Foundations and Trends
in Optimization, 1(3), 123–231., p. 152 be used?}

\item{maxIterOut}{maximal number of outer iterations}

\item{maxIterIn}{maximal number of inner iterations}

\item{breakOuter}{change in fit required to break the outer iteration. Note: The
value will be multiplied internally with sample size N as the -2log-Likelihood
depends directly on the sample size}

\item{convCritInner}{this is related to the inner breaking condition.
0 = ista, as presented by Beck & Teboulle (2009); see Remark 3.1 on p. 191 (ISTA with backtracking)
1 = gist, as presented by Gong et al. (2013) (Equation 3)}

\item{sigma}{sigma in (0,1) is used by the gist convergence criterion. larger
sigma enforce larger improvement in fit}

\item{stepSizeInheritance}{how should step sizes be carried forward from iteration to iteration?
0 = resets the step size to L0 in each iteration
1 = takes the previous step size as initial value for the next iteration
3 = Barzilai-Borwein procedure
4 = Barzilai-Borwein procedure, but sometimes resets the step size; this can help when the optimizer is caught in a bad spot.}

\item{verbose}{if set to a value > 0, the fit every "verbose" iterations is printed.}

\item{nCores}{number of core to use. Multi-core support is provided by RcppParallel and only supported for SEM, not for general purpose optimization.}
}
\value{
object of class controlIsta
}
\description{
controlIsta
}
\examples{
control <- controlIsta()
}
