#' SO-CAL Google Polarity Table
#'
#' A \pkg{data.table} dataset containing a version of Taboada, Brooke, Tofiloski,
#' Voll, & Stede's (2011) positive/negative word list as sentiment lookup
#' values.
#'
#' @details
#' \itemize{
#'   \item x. Words
#'   \item y. Sentiment values
#' }
#'
#' @docType data
#' @keywords datasets
#' @name hash_sentiment_socal_google
#' @usage data(hash_sentiment_socal_google)
#' @format A data frame with 3272 rows and 2 variables
#' @references Taboada, M., Brooke, J., Tofiloski, M., Voll, K., and Stede, M.
#' (2011). Lexicon-based methods for sentiment analysis. Computational
#' Linguistics, 37(2). 267-307. \cr \cr
#' \url{https://github.com/sfu-discourse-lab/SO-CAL}
NULL

