% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waldtest.R
\name{waldtest}
\alias{waldtest}
\title{Compute Wald test for joint restrictions on coefficients}
\usage{
waldtest(object, R, r, type = c("default", "iid", "robust", "cluster"),
  lhs = NULL, df1, df2)
}
\arguments{
\item{object}{object of class \code{"felm"}, a result of a call to
\code{\link{felm}}.}

\item{R}{matrix, character, formula, function, integer or logical.
Specification of which exclusions to test.}

\item{r}{numerical vector.}

\item{type}{character. Error structure type.}

\item{lhs}{character. Name of left hand side if multiple left hand sides.}

\item{df1}{integer. If you know better than the default df, specify it here.}

\item{df2}{integer. If you know better than the default df, specify it here.}
}
\value{
The function \code{waldtest} computes and returns a named numeric
vector containing the following elements.

\itemize{ \item \code{p} is the p-value for the Chi^2-test \item \code{chi2}
is the Chi^2-distributed statistic.  \item \code{df1} is the degrees of
freedom for the Chi^2 statistic.  \item \code{p.F} is the p-value for the F
statistics \item \code{F} is the F-distributed statistic.  \item \code{df2}
is the additional degrees of freedom for the F statistic. }

The return value has an attribute \code{'formula'} which encodes the
restrictions.
}
\description{
Compute a Wald test for a linear hypothesis on the coefficients.  Also
supports Delta-approximation for non-linear hypotheses.
}
\details{
The function \code{waldtest} computes a Wald test for the H0: R beta = r,
where beta is the estimated vector \code{coef(object)}.

If \code{R} is a character, integer, or logical vector it is assumed to
specify a matrix which merely picks out a subset of the coefficients for
joint testing. If \code{r} is not specified, it is assumed to be a zero
vector of the appropriate length.

\code{R} can also be a formula which is linear in the estimated
coefficients, e.g. of the type \code{~Q-2|x-2*z} which will test the joint
hypothesis Q=2 and x=2*z.

If \code{R} is a function (of the coefficients), an approximate Wald test
against H0: \code{R(beta) == 0}, using the Delta-method, is computed.

In case of an IV-estimation, the names for the endogenous variables in
\code{coef(object)} are of the type \code{"`Q(fit)`"} which is a bit dull to
type; if all the endogenous variables are to be tested they can be specified
as \code{"endovars"}. It is also possible to specify an endogenous variable
simply as \code{"Q"}, and \code{waldtest} will add the other syntactic sugar
to obtain \code{"`Q(fit)`"}.

The \code{type} argument works as follows. If \code{type=='default'} it is
assumed that the residuals are i.i.d., unless a cluster structure was
specified to \code{\link{felm}}. If \code{type=='robust'}, a heteroscedastic
structure is assumed, even if a cluster structure was specified in
\code{\link{felm}}.
}
\examples{

x <- rnorm(10000)
x2 <- rnorm(length(x))
y <- x - 0.2*x2 + rnorm(length(x))
#Also works for lm
summary(est <- lm(y ~ x + x2  ))
# We do not reject the true values
waldtest(est, ~ x-1|x2+0.2|`(Intercept)`)
# The Delta-method coincides when the function is linear:
waldtest(est, function(x) x - c(0, 1, -0.2))

}
\seealso{
\code{\link{nlexpect}}
}

