% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-create_model-covariates.R
\name{create_model.covs_and_comps}
\alias{create_model.covs_and_comps}
\title{Parse the covariates and model components from given data and formula}
\usage{
create_model.covs_and_comps(data, model_formula, x_cont_scl, verbose)
}
\arguments{
\item{data}{A \code{data.frame} where each column corresponds to one
variable, and each row is one observation. Continuous covariates and the
response variable must have type \code{"numeric"} and categorical covariates
must have type \code{"factor"}. Missing values should be indicated with
\code{NaN} or \code{NA}. The response variable cannot contain missing
values. Column names should not contain trailing or leading underscores.}

\item{model_formula}{an object of class \linkS4class{lgpformula}}

\item{x_cont_scl}{Information on how to scale the continuous covariates.
This can either be
\itemize{
  \item an existing list of objects with class \linkS4class{lgpscaling}, or
  \item \code{NA}, in which case such list is created by computing mean
  and standard deviation from \code{data}
}}

\item{verbose}{Should some informative messages be printed?}
}
\value{
parsed input to Stan and covariate scaling, and other info
}
\description{
Parse the covariates and model components from given data and formula
}
\seealso{
Other internal model creation functions: 
\code{\link{create_model.formula}()},
\code{\link{create_model.likelihood}()},
\code{\link{create_model.prior}()}
}
\concept{internal model creation functions}
