% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main-draw_pred.R
\name{draw_pred}
\alias{draw_pred}
\title{Draw pseudo-observations from posterior or prior predictive distribution}
\usage{
draw_pred(fit, pred = NULL)
}
\arguments{
\item{fit}{An object of class \linkS4class{lgpfit} that has been created
using the \code{\link{lgp}} option \code{sample_f=TRUE}.}

\item{pred}{An object of class \linkS4class{Prediction}, containing
draws of each model component. If \code{NULL}, this is
obtained using \code{get_pred(fit)}.}
}
\value{
An array with shape \eqn{S x P}, where \eqn{S} is the number of
draws that \code{pred} contains and \eqn{P} is the length of each
function draw.
Each row \eqn{s = 1, \ldots, S} of the output is one vector drawn from the
predictive distribution, given parameter draw \eqn{s}.
}
\description{
Draw pseudo-observations from predictive distribution.
If \code{pred} contains draws from the component posterior (prior)
distributions, then the output is draws from the posterior (prior)
predictive distribution. If \code{pred} is not specified, then
whether output draws are from prior or posterior predictive distribution
depends on whether \code{fit} is created using the \code{\link{lgp}}
option \code{prior_only=TRUE} or not.
}
\seealso{
Other main functions: 
\code{\link{create_model}()},
\code{\link{get_draws}()},
\code{\link{lgp}()},
\code{\link{pred}()},
\code{\link{prior_pred}()},
\code{\link{sample_model}()}
}
\concept{main functions}
