% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppenderAWSCloudWatchLog.R
\name{AppenderAWSCloudWatchLog}
\alias{AppenderAWSCloudWatchLog}
\title{Log to AWS CloudWatch Logs}
\value{
The \verb{$new()} method returns an \link[R6:R6Class]{R6::R6} that inherits from
\link[lgr:Appender]{lgr::Appender} and can be uses as an appender by a \link[lgr:Logger]{lgr::Logger}.
}
\description{
Log to \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html}{AWS CloudWatch Logs}.
}
\section{Buffered Logging}{


By default, \code{AppenderAWSCloudWatchLog} writes each LogEvent which can be relatively slow.
To improve performance it is possible to tell
AppenderAWSCloudWatchLog to buffer db writes by setting \code{buffer_size} to something greater
than \code{0}. This buffer is written to AWS CloudWatch whenever it is full
(\code{buffer_size}), whenever a LogEvent with a level of \code{fatal} or \code{error} is
encountered (\code{flush_threshold}), or when the Appender is garbage collected
(\code{flush_on_exit}), i.e. when you close the \R session or shortly after you
remove the Appender object via \code{rm()}.
}

\section{Creating a New Appender}{


An \code{AppenderAWSCloudWatchLog} is linked to an AWS Account using the
\href{https://www.paws-r-sdk.com/}{paws sdk package}. If the
log group does not exist it is created either when the Appender is first
instantiated or (more likely) when the first LogEvent would be written to
that table.
}

\examples{
\dontrun{
  library(lgrExtra)
  app <- AppenderAWSCloudWatchLog$new(log_group_name = "lgrExtra")
  lg <- lgr::get_logger("lgrExtra")$add_appender(app)$set_propagate(FALSE)
  lg$info("test")
  print(lg$appenders[[1]]$data)

  invisible(lg$config(NULL))  # cleanup
}
}
\seealso{
Other Appenders: 
\code{\link{AppenderDbi}},
\code{\link{AppenderDt}},
\code{\link{AppenderDynatrace}},
\code{\link{AppenderElasticSearch}},
\code{\link{AppenderGmail}},
\code{\link{AppenderPool}},
\code{\link{AppenderPushbullet}},
\code{\link{AppenderSendmail}},
\code{\link{AppenderSyslog}}
}
\concept{Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{\link[lgr:AppenderMemory]{lgr::AppenderMemory}} -> \code{AppenderAWSCloudWatchLog}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{client}}{a \link[paws.management:cloudwatchlogs]{paws.management cloudwatchlogs client}}

\item{\code{log_group_name}}{The name of the AWS CloudWatch log group.}

\item{\code{log_stream_name}}{The name of the log stream within the \code{log_group_name}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AppenderAWSCloudWatchLog-new}{\code{AppenderAWSCloudWatchLog$new()}}
\item \href{#method-AppenderAWSCloudWatchLog-set_client}{\code{AppenderAWSCloudWatchLog$set_client()}}
\item \href{#method-AppenderAWSCloudWatchLog-set_log_group_name}{\code{AppenderAWSCloudWatchLog$set_log_group_name()}}
\item \href{#method-AppenderAWSCloudWatchLog-set_log_stream_name}{\code{AppenderAWSCloudWatchLog$set_log_stream_name()}}
\item \href{#method-AppenderAWSCloudWatchLog-set_log_group_retention_days}{\code{AppenderAWSCloudWatchLog$set_log_group_retention_days()}}
\item \href{#method-AppenderAWSCloudWatchLog-flush}{\code{AppenderAWSCloudWatchLog$flush()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-add_filter'><code>lgr::Filterable$add_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter"><a href='../../lgr/html/Filterable.html#method-Filterable-filter'><code>lgr::Filterable$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-remove_filter'><code>lgr::Filterable$remove_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters"><a href='../../lgr/html/Filterable.html#method-Filterable-set_filters'><code>lgr::Filterable$set_filters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout"><a href='../../lgr/html/Appender.html#method-Appender-set_layout'><code>lgr::Appender$set_layout()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold"><a href='../../lgr/html/Appender.html#method-Appender-set_threshold'><code>lgr::Appender$set_threshold()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="append"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-append'><code>lgr::AppenderMemory$append()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="clear"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-clear'><code>lgr::AppenderMemory$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="format"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-format'><code>lgr::AppenderMemory$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_buffer_size"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_buffer_size'><code>lgr::AppenderMemory$set_buffer_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_exit"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_flush_on_exit'><code>lgr::AppenderMemory$set_flush_on_exit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_rotate"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_flush_on_rotate'><code>lgr::AppenderMemory$set_flush_on_rotate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_threshold"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_flush_threshold'><code>lgr::AppenderMemory$set_flush_threshold()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_should_flush"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_should_flush'><code>lgr::AppenderMemory$set_should_flush()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="show"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-show'><code>lgr::AppenderMemory$show()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderAWSCloudWatchLog-new"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderAWSCloudWatchLog-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderAWSCloudWatchLog$new(
  log_group_name,
  log_stream_name = paste(log_group_name, Sys.Date(), sep = "/"),
  log_group_retention_days = NULL,
  paws_config = list(),
  threshold = NA_integer_,
  layout = LayoutFormat$new(fmt = "\%L: \%m", colors = list()),
  buffer_size = 0,
  flush_threshold = "error",
  flush_on_exit = TRUE,
  flush_on_rotate = TRUE,
  should_flush = NULL,
  filters = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{log_group_name}}{The name of the AWS CloudWatch log group.}

\item{\code{log_stream_name}}{The name of the log stream within the \code{log_group_name}.}

\item{\code{log_group_retention_days}}{The number of days to retain the log events in the specified log group.
\href{https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html}{AWS API Documentation}}

\item{\code{paws_config}}{list of paws config. Please see section \url{https://www.paws-r-sdk.com/docs/set_service_parameter/}}

\item{\code{threshold, flush_threshold, layout, buffer_size}}{see \link[lgr:AppenderBuffer]{lgr::AppenderBuffer}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderAWSCloudWatchLog-set_client"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderAWSCloudWatchLog-set_client}{}}}
\subsection{Method \code{set_client()}}{
set \code{paws.management} \code{cloudwatchlogs} client
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderAWSCloudWatchLog$set_client(client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{(\code{paws.management::cloudwatchlogs}) client.
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html}{AWS CloudWatch}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderAWSCloudWatchLog-set_log_group_name"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderAWSCloudWatchLog-set_log_group_name}{}}}
\subsection{Method \code{set_log_group_name()}}{
set log group name for AWS CloudWatch
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderAWSCloudWatchLog$set_log_group_name(log_group_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{log_group_name}}{(character) name of AWS CloudWatch}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderAWSCloudWatchLog-set_log_stream_name"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderAWSCloudWatchLog-set_log_stream_name}{}}}
\subsection{Method \code{set_log_stream_name()}}{
set log stream name within AWS CloudWatch log group
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderAWSCloudWatchLog$set_log_stream_name(log_stream_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{log_stream_name}}{(character) log stream name with AWS CloudWatch log group}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderAWSCloudWatchLog-set_log_group_retention_days"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderAWSCloudWatchLog-set_log_group_retention_days}{}}}
\subsection{Method \code{set_log_group_retention_days()}}{
set log group retention days for AWS CloudWatch Log Group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderAWSCloudWatchLog$set_log_group_retention_days(log_group_retention_days)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{log_group_retention_days}}{The number of days to retain the log events in the specified log group.
\href{https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html}{AWS API Documentation}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderAWSCloudWatchLog-flush"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderAWSCloudWatchLog-flush}{}}}
\subsection{Method \code{flush()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderAWSCloudWatchLog$flush()}\if{html}{\out{</div>}}
}

}
}
