% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{is_valid_issn}
\alias{is_valid_issn}
\title{Return TRUE if valid ISSN}
\usage{
is_valid_issn(x, allow.hyphens = TRUE, lower.x.allowed = TRUE)
}
\arguments{
\item{x}{A string of 8 digits or 7 digits with terminal "X"}

\item{allow.hyphens}{A logical indicating whether the hyphen
separator should be allowed}

\item{lower.x.allowed}{A logical indicating whether ISSNs with
a check digit with a lower-case "x" should
be treated as valid}
}
\value{
Returns TRUE if checks pass, FALSE if not, and NA if NA
}
\description{
Takes a string representation of an ISSN verifies that it is valid.
An ISSN is valid if it is a 8 digit string or a 7 digit string
with a terminal "X" AND the check digit matches
}
\examples{

is_valid_issn("2434561X")           # TRUE
is_valid_issn("2434-561X")          # TRUE

# vectorized

is_valid_issn(c("2434-561X", "2434-5611", "0378-5955", NA))
# TRUE FALSE TRUE NA

}
