% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{dt_set_clean_names}
\alias{dt_set_clean_names}
\title{Takes a data.table and set to cleaned column names}
\usage{
dt_set_clean_names(DT, lower = TRUE)
}
\arguments{
\item{DT}{a data.table}

\item{lower}{A logical indicating whether all column names should be
made lower case (default \code{TRUE}).}
}
\value{
Returns the data.table but with cleaned names
}
\description{
This function takes a data.table, and returns the same data.table
with column names that are cleaned and stripped of potentially
troublesome names
}
\details{
All space/whitespace characters are replaced with underscores,
as are all characters not from A-Z, a-z, an underscore, or a digit
}
\examples{

ejemplo <- as.data.table(iris)
setnames(ejemplo, c("Sepal Length", "Sepal@Width", "Petal	Length",
                    "Petal\\\\nWidth", "Spêcies"))
dt_set_clean_names(ejemplo)

}
\seealso{
\code{\link{get_clean_names}}
}
