% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_export}
\alias{lib_export}
\title{Export a Data Library}
\usage{
lib_export(x, nm, directory_path, engine, filter = NULL, standard_eval = FALSE)
}
\arguments{
\item{x}{The library to export.}

\item{nm}{The variable name to hold the new library.
The parameter will assume non-standard
(unquoted) evaluation unless the \code{standard_eval} parameter is set
to TRUE.}

\item{directory_path}{The path to export the library to.}

\item{engine}{The name of the engine to use for the exported data.
The engine name corresponds to the standard file extension 
of the data file type. Valid values are 'rds', 'Rdata', 'rda', 'sas7bdat', 
'xpt', 'xls', 'xlsx', 'dbf', and 'csv'.}

\item{filter}{A filter string to limit which datasets are exported. 
The filter parameter accepts wildcards.}

\item{standard_eval}{A TRUE or FALSE value which indicates whether to 
use standard (quoted) or non-standard (unquoted) evaluation on the 
\code{nm} parameter. Default is FALSE.  Use this parameter if you want to 
pass the target library name in a variable.}
}
\value{
The newly exported library.
}
\description{
The \code{lib_export} function exports a data library to
another library with a different directory and file format.  The 
function accepts a library to export, the new library name,
 a destination path, and an engine name.  
If the destination 
path does not exist, the function will attempt to create it.  

Note that
the export will result in the current data in memory written to the new
destination directory.  If the library is loaded into the workspace, 
the workspace version will be considered the most current version, and
that is the version that will be exported.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create library
libname(dat1, tmp)

# Add dat to library
lib_add(dat1, mtcars, iris)

# Export dat1 to dat2
lib_export(dat1, dat2, file.path(tmp, "export"), "rdata")
# library 'dat2': 2 items
# - attributes: rdata not loaded
# - path: C:\Users\User\AppData\Local\Temp\Rtmp0Sq3kt/export
# - items:
#     Name Extension Rows Cols   Size        LastModified
# 1 mtcars     rdata   32   11 8.1 Kb 2022-06-23 00:10:52
# 2   iris     rdata  150    5 8.1 Kb 2022-06-23 00:10:52

# Clean up
lib_delete(dat1)
lib_delete(dat2)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
