% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\name{import_spec}
\alias{import_spec}
\title{Create an Import Specification}
\usage{
import_spec(..., na = NULL, trim_ws = NULL)
}
\arguments{
\item{...}{Named pairs of column names and column data types.
Available types are: 'guess', 'logical', 'character', 'integer', 'numeric',
'date', 'datetime', and 'time'.  The date/time data types accept an optional
input format.  To supply the input format, append it after the data type
following an equals sign, e.g.: 'date=\%d\%B\%Y' or 
'datetime=\%d\%m\%Y \%H:\%M:\%S'. Default is NULL, meaning no column 
types are specified, and the function should make its best 
guess for each column.}

\item{na}{A vector of values to be treated as NA.  For example, the 
vector \code{c('', ' ')} will cause empty strings and single blanks to 
be converted to NA values. Default is NULL, meaning the value of the 
\code{na} parameter will be taken from the \code{\link{specs}} function.
Any value supplied on the \code{import_spec} function will override the 
value from the \code{specs} function.}

\item{trim_ws}{Whether or not to trim white space from the input data values.
The default is NULL, meaning the value of the \code{trim_ws} parameter
will be taken from the \code{\link{specs}} function.  Any value supplied 
on the \code{import_spec} function will override the value from the 
\code{specs} function.}
}
\value{
The import specification object.
}
\description{
A function to create the import specifications for a 
particular data file.  This information can be used on the 
\code{\link{libname}} function to correctly assign the data types for 
columns on imported data. The import specifications are defined as 
name/value pairs, where the name is the column name and the value is the
data type indicator.  Available data type indicators are 
'guess', 'logical', 'character', 'integer', 'numeric',
'date', 'datetime', and 'time'.  See the \code{\link{specs}} function
for an example of using import specs.
}
\seealso{
\code{\link{libname}} to create a data library, and 
\code{\link{specs}} for an example using import specs.

Other specs: 
\code{\link{print.specs}()},
\code{\link{read.specs}()},
\code{\link{specs}()},
\code{\link{write.specs}()}
}
\concept{specs}
