/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include <R.h>
#include <Rdefines.h>
#include <so.h>
#include "soc.h"

SEXP r_so_Estimation_new()
{
	so_Estimation *obj = so_Estimation_new();
	if (!obj) {
		error("Failed to create so_Estimation object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_Estimation_copy(SEXP self)
{
	so_Estimation *obj = so_Estimation_copy(R_ExternalPtrAddr(self));
	if (!obj) {
		error("Failed to copy so_Estimation object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_Estimation_free(SEXP self)
{
	so_Estimation_free(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Estimation_ref(SEXP self)
{
	so_Estimation_ref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Estimation_unref(SEXP self)
{
	so_Estimation_unref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_Estimation_get_PopulationEstimates(SEXP self)
{
	so_PopulationEstimates *child = so_Estimation_get_PopulationEstimates(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_Estimation_set_PopulationEstimates(SEXP self, SEXP child)
{
	so_Estimation_set_PopulationEstimates(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_Estimation_create_PopulationEstimates(SEXP self)
{
	so_PopulationEstimates *child = so_Estimation_create_PopulationEstimates(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Estimation_get_PrecisionPopulationEstimates(SEXP self)
{
	so_PrecisionPopulationEstimates *child = so_Estimation_get_PrecisionPopulationEstimates(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_Estimation_set_PrecisionPopulationEstimates(SEXP self, SEXP child)
{
	so_Estimation_set_PrecisionPopulationEstimates(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_Estimation_create_PrecisionPopulationEstimates(SEXP self)
{
	so_PrecisionPopulationEstimates *child = so_Estimation_create_PrecisionPopulationEstimates(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Estimation_get_IndividualEstimates(SEXP self)
{
	so_IndividualEstimates *child = so_Estimation_get_IndividualEstimates(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_Estimation_set_IndividualEstimates(SEXP self, SEXP child)
{
	so_Estimation_set_IndividualEstimates(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_Estimation_create_IndividualEstimates(SEXP self)
{
	so_IndividualEstimates *child = so_Estimation_create_IndividualEstimates(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Estimation_get_PrecisionIndividualEstimates(SEXP self)
{
	so_PrecisionIndividualEstimates *child = so_Estimation_get_PrecisionIndividualEstimates(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_Estimation_set_PrecisionIndividualEstimates(SEXP self, SEXP child)
{
	so_Estimation_set_PrecisionIndividualEstimates(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_Estimation_create_PrecisionIndividualEstimates(SEXP self)
{
	so_PrecisionIndividualEstimates *child = so_Estimation_create_PrecisionIndividualEstimates(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Estimation_get_Residuals(SEXP self)
{
	so_Residuals *child = so_Estimation_get_Residuals(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_Estimation_set_Residuals(SEXP self, SEXP child)
{
	so_Estimation_set_Residuals(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_Estimation_create_Residuals(SEXP self)
{
	so_Residuals *child = so_Estimation_create_Residuals(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Estimation_get_Predictions(SEXP self)
{
	so_Table *child = so_Estimation_get_Predictions(R_ExternalPtrAddr(self));
	SEXP result = table2df(child);
	return result;
}

SEXP r_so_Estimation_set_Predictions(SEXP self, SEXP child)
{
	so_Table *table = df2table(child);
	so_Estimation_set_Predictions(R_ExternalPtrAddr(self), table);
	return R_NilValue;
}

SEXP r_so_Estimation_create_Predictions(SEXP self)
{
	so_Table *child = so_Estimation_create_Predictions(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Estimation_get_OFMeasures(SEXP self)
{
	so_OFMeasures *child = so_Estimation_get_OFMeasures(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_Estimation_set_OFMeasures(SEXP self, SEXP child)
{
	so_Estimation_set_OFMeasures(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_Estimation_create_OFMeasures(SEXP self)
{
	so_OFMeasures *child = so_Estimation_create_OFMeasures(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_Estimation_get_TargetToolMessages(SEXP self)
{
	so_TargetToolMessages *child = so_Estimation_get_TargetToolMessages(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_Estimation_set_TargetToolMessages(SEXP self, SEXP child)
{
	so_Estimation_set_TargetToolMessages(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_Estimation_create_TargetToolMessages(SEXP self)
{
	so_TargetToolMessages *child = so_Estimation_create_TargetToolMessages(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

