# libsoc - Library to handle standardised output files
# Copyright (C) 2015 Rikard Nordgren
# 
# This file was autogenerated and should not be edited
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# his library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, see <http://www.gnu.org/licenses/>.

so_SimulationBlock_new <- function() {
	obj = .Call("r_so_SimulationBlock_new")
}

so_SimulationBlock_copy <- function(self) {
	.Call("r_so_SimulationBlock_copy", self)
}

so_SimulationBlock_free <- function(self) {
	.Call("r_so_SimulationBlock_free", self)
}

so_SimulationBlock_ref <- function(self) {
	.Call("r_so_SimulationBlock_ref", self)
}

so_SimulationBlock_unref <- function(self) {
	.Call("r_so_SimulationBlock_unref", self)
}

so_SimulationBlock_get_replicate <- function(self) {
	.Call("r_so_SimulationBlock_get_replicate", self)
}

so_SimulationBlock_set_replicate <- function(self, value) {
	.Call("r_so_SimulationBlock_set_replicate", self, value)
}

so_SimulationBlock_get_SimulatedProfiles <- function(self, number) {
	.Call("r_so_SimulationBlock_get_SimulatedProfiles", self, number)
}

so_SimulationBlock_get_number_of_SimulatedProfiles <- function(self) {
	.Call("r_so_SimulationBlock_get_number_of_SimulatedProfiles", self)
}
so_SimulationBlock_add_SimulatedProfiles <- function(self, value) {
	.Call("r_so_SimulationBlock_add_SimulatedProfiles", self, value)
}
so_SimulationBlock_remove_SimulatedProfiles <- function(self, index) {
	.Call("r_so_SimulationBlock_remove_SimulatedProfiles", self, index)
}

so_SimulationBlock_create_SimulatedProfiles <- function(self) {
	.Call("r_so_SimulationBlock_create_SimulatedProfiles", self)
}

so_SimulationBlock_get_IndivParameters <- function(self, number) {
	.Call("r_so_SimulationBlock_get_IndivParameters", self, number)
}

so_SimulationBlock_get_number_of_IndivParameters <- function(self) {
	.Call("r_so_SimulationBlock_get_number_of_IndivParameters", self)
}
so_SimulationBlock_add_IndivParameters <- function(self, value) {
	.Call("r_so_SimulationBlock_add_IndivParameters", self, value)
}
so_SimulationBlock_remove_IndivParameters <- function(self, index) {
	.Call("r_so_SimulationBlock_remove_IndivParameters", self, index)
}

so_SimulationBlock_create_IndivParameters <- function(self) {
	.Call("r_so_SimulationBlock_create_IndivParameters", self)
}

so_SimulationBlock_get_RandomEffects <- function(self, number) {
	.Call("r_so_SimulationBlock_get_RandomEffects", self, number)
}

so_SimulationBlock_get_number_of_RandomEffects <- function(self) {
	.Call("r_so_SimulationBlock_get_number_of_RandomEffects", self)
}
so_SimulationBlock_add_RandomEffects <- function(self, value) {
	.Call("r_so_SimulationBlock_add_RandomEffects", self, value)
}
so_SimulationBlock_remove_RandomEffects <- function(self, index) {
	.Call("r_so_SimulationBlock_remove_RandomEffects", self, index)
}

so_SimulationBlock_create_RandomEffects <- function(self) {
	.Call("r_so_SimulationBlock_create_RandomEffects", self)
}

so_SimulationBlock_get_Covariates <- function(self, number) {
	.Call("r_so_SimulationBlock_get_Covariates", self, number)
}

so_SimulationBlock_get_number_of_Covariates <- function(self) {
	.Call("r_so_SimulationBlock_get_number_of_Covariates", self)
}
so_SimulationBlock_add_Covariates <- function(self, value) {
	.Call("r_so_SimulationBlock_add_Covariates", self, value)
}
so_SimulationBlock_remove_Covariates <- function(self, index) {
	.Call("r_so_SimulationBlock_remove_Covariates", self, index)
}

so_SimulationBlock_create_Covariates <- function(self) {
	.Call("r_so_SimulationBlock_create_Covariates", self)
}

so_SimulationBlock_get_Regressors <- function(self, number) {
	.Call("r_so_SimulationBlock_get_Regressors", self, number)
}

so_SimulationBlock_get_number_of_Regressors <- function(self) {
	.Call("r_so_SimulationBlock_get_number_of_Regressors", self)
}
so_SimulationBlock_add_Regressors <- function(self, value) {
	.Call("r_so_SimulationBlock_add_Regressors", self, value)
}
so_SimulationBlock_remove_Regressors <- function(self, index) {
	.Call("r_so_SimulationBlock_remove_Regressors", self, index)
}

so_SimulationBlock_create_Regressors <- function(self) {
	.Call("r_so_SimulationBlock_create_Regressors", self)
}

so_SimulationBlock_get_PopulationParameters <- function(self, number) {
	.Call("r_so_SimulationBlock_get_PopulationParameters", self, number)
}

so_SimulationBlock_get_number_of_PopulationParameters <- function(self) {
	.Call("r_so_SimulationBlock_get_number_of_PopulationParameters", self)
}
so_SimulationBlock_add_PopulationParameters <- function(self, value) {
	.Call("r_so_SimulationBlock_add_PopulationParameters", self, value)
}
so_SimulationBlock_remove_PopulationParameters <- function(self, index) {
	.Call("r_so_SimulationBlock_remove_PopulationParameters", self, index)
}

so_SimulationBlock_create_PopulationParameters <- function(self) {
	.Call("r_so_SimulationBlock_create_PopulationParameters", self)
}

so_SimulationBlock_get_Dosing <- function(self, number) {
	.Call("r_so_SimulationBlock_get_Dosing", self, number)
}

so_SimulationBlock_get_number_of_Dosing <- function(self) {
	.Call("r_so_SimulationBlock_get_number_of_Dosing", self)
}
so_SimulationBlock_add_Dosing <- function(self, value) {
	.Call("r_so_SimulationBlock_add_Dosing", self, value)
}
so_SimulationBlock_remove_Dosing <- function(self, index) {
	.Call("r_so_SimulationBlock_remove_Dosing", self, index)
}

so_SimulationBlock_create_Dosing <- function(self) {
	.Call("r_so_SimulationBlock_create_Dosing", self)
}

so_SimulationBlock_get_RawResultsFile <- function(self) {
	.Call("r_so_SimulationBlock_get_RawResultsFile", self)
}

so_SimulationBlock_set_RawResultsFile <- function(self, value) {
	.Call("r_so_SimulationBlock_set_RawResultsFile", self, value)
}

so_SimulationBlock_create_RawResultsFile <- function(self) {
	.Call("r_so_SimulationBlock_create_RawResultsFile", self)
}

replicate_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			so_SimulationBlock_get_replicate(.self$.cobj)
		} else {
			stopifnot(length(value) == 1)
			value = as.integer(value)
			so_SimulationBlock_set_replicate(.self$.cobj, value)
		}
	}
}

SimulatedProfiles_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_SimulationBlock_get_number_of_SimulatedProfiles(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_SimulationBlock_get_SimulatedProfiles(.self$.cobj, i - 1L)
					a[[i]] = so_SimulationSubType$new(cobj=child)
					so_SimulationSubType_ref(child)
				}
				return(a)
			}
		} else {
		}
	}
}

IndivParameters_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_SimulationBlock_get_number_of_IndivParameters(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_SimulationBlock_get_IndivParameters(.self$.cobj, i - 1L)
					a[[i]] = so_SimulationSubType$new(cobj=child)
					so_SimulationSubType_ref(child)
				}
				return(a)
			}
		} else {
		}
	}
}

RandomEffects_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_SimulationBlock_get_number_of_RandomEffects(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_SimulationBlock_get_RandomEffects(.self$.cobj, i - 1L)
					a[[i]] = so_SimulationSubType$new(cobj=child)
					so_SimulationSubType_ref(child)
				}
				return(a)
			}
		} else {
		}
	}
}

Covariates_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_SimulationBlock_get_number_of_Covariates(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_SimulationBlock_get_Covariates(.self$.cobj, i - 1L)
					a[[i]] = so_SimulationSubType$new(cobj=child)
					so_SimulationSubType_ref(child)
				}
				return(a)
			}
		} else {
		}
	}
}

Regressors_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_SimulationBlock_get_number_of_Regressors(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_SimulationBlock_get_Regressors(.self$.cobj, i - 1L)
					a[[i]] = so_SimulationSubType$new(cobj=child)
					so_SimulationSubType_ref(child)
				}
				return(a)
			}
		} else {
		}
	}
}

PopulationParameters_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_SimulationBlock_get_number_of_PopulationParameters(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_SimulationBlock_get_PopulationParameters(.self$.cobj, i - 1L)
					a[[i]] = so_SimulationSubType$new(cobj=child)
					so_SimulationSubType_ref(child)
				}
				return(a)
			}
		} else {
		}
	}
}

Dosing_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_SimulationBlock_get_number_of_Dosing(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_SimulationBlock_get_Dosing(.self$.cobj, i - 1L)
					a[[i]] = so_SimulationSubType$new(cobj=child)
					so_SimulationSubType_ref(child)
				}
				return(a)
			}
		} else {
		}
	}
}

RawResultsFile_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			child = so_SimulationBlock_get_RawResultsFile(.self$.cobj)
			if (!isnull(child)) {
				so_ExternalFile_ref(child)
				so_ExternalFile$new(cobj=child)
			}
		} else {
			if (!is(value, "so_ExternalFile")) {
				stop("object must be of type 'so_ExternalFile'")
			}
			so_SimulationBlock_set_RawResultsFile(.self$.cobj, value$.cobj)
			so_ExternalFile_ref(value$.cobj)
		}
	}
}

so_SimulationBlock = setRefClass("so_SimulationBlock",
	fields=list(
		replicate = replicate_acc,
		SimulatedProfiles = SimulatedProfiles_acc,
		IndivParameters = IndivParameters_acc,
		RandomEffects = RandomEffects_acc,
		Covariates = Covariates_acc,
		Regressors = Regressors_acc,
		PopulationParameters = PopulationParameters_acc,
		Dosing = Dosing_acc,
		RawResultsFile = RawResultsFile_acc,
		.cobj = "externalptr"
	),
	methods=list(
		copy = function() {
			copy = so_SimulationBlock_copy(.self$.cobj)
			so_SimulationBlock$new(cobj=copy)
		},
		initialize = function(cobj) {
			if (missing(cobj)) {
				.cobj <<- so_SimulationBlock_new()
			} else {
				.cobj <<- cobj
			}
		},
		finalize = function() {
			so_SimulationBlock_unref(.self$.cobj)
		},
		add_SimulatedProfiles = function(value) {
			so_SimulationBlock_add_SimulatedProfiles(.self$.cobj, value$.cobj)
			invisible(so_SimulationSubType_ref(value$.cobj))
		},
		remove_SimulatedProfiles = function(value, index) {
			invisible(so_SimulationBlock_remove_SimulatedProfiles(.self$.cobj, index))
		},
		add_IndivParameters = function(value) {
			so_SimulationBlock_add_IndivParameters(.self$.cobj, value$.cobj)
			invisible(so_SimulationSubType_ref(value$.cobj))
		},
		remove_IndivParameters = function(value, index) {
			invisible(so_SimulationBlock_remove_IndivParameters(.self$.cobj, index))
		},
		add_RandomEffects = function(value) {
			so_SimulationBlock_add_RandomEffects(.self$.cobj, value$.cobj)
			invisible(so_SimulationSubType_ref(value$.cobj))
		},
		remove_RandomEffects = function(value, index) {
			invisible(so_SimulationBlock_remove_RandomEffects(.self$.cobj, index))
		},
		add_Covariates = function(value) {
			so_SimulationBlock_add_Covariates(.self$.cobj, value$.cobj)
			invisible(so_SimulationSubType_ref(value$.cobj))
		},
		remove_Covariates = function(value, index) {
			invisible(so_SimulationBlock_remove_Covariates(.self$.cobj, index))
		},
		add_Regressors = function(value) {
			so_SimulationBlock_add_Regressors(.self$.cobj, value$.cobj)
			invisible(so_SimulationSubType_ref(value$.cobj))
		},
		remove_Regressors = function(value, index) {
			invisible(so_SimulationBlock_remove_Regressors(.self$.cobj, index))
		},
		add_PopulationParameters = function(value) {
			so_SimulationBlock_add_PopulationParameters(.self$.cobj, value$.cobj)
			invisible(so_SimulationSubType_ref(value$.cobj))
		},
		remove_PopulationParameters = function(value, index) {
			invisible(so_SimulationBlock_remove_PopulationParameters(.self$.cobj, index))
		},
		add_Dosing = function(value) {
			so_SimulationBlock_add_Dosing(.self$.cobj, value$.cobj)
			invisible(so_SimulationSubType_ref(value$.cobj))
		},
		remove_Dosing = function(value, index) {
			invisible(so_SimulationBlock_remove_Dosing(.self$.cobj, index))
		}
	)
)
