% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-its.r
\name{dalponte2016}
\alias{dalponte2016}
\title{Individual Tree Segmentation Algorithm}
\usage{
dalponte2016(chm, treetops, th_tree = 2, th_seed = 0.45,
  th_cr = 0.55, max_cr = 10, ID = "treeID")
}
\arguments{
\item{chm}{RasterLayer. Image of the canopy. Can be computed with \link{grid_canopy} or read from
an external file.}

\item{treetops}{\code{SpatialPointsDataFrame}. Can be computed with
\link[lidR:tree_detection]{tree_detection} or read from an external shapefile.}

\item{th_tree}{numeric. Threshold below which a pixel cannot be a tree. Default is 2.}

\item{th_seed}{numeric. Growing threshold 1. See reference in Dalponte et al. 2016. A pixel
is added to a region if its height is greater than the tree height multiplied by this value.
It should be between 0 and 1. Default is 0.45.}

\item{th_cr}{numeric. Growing threshold 2. See reference in Dalponte et al. 2016. A pixel
is added to a region if its height is greater than the current mean height of the region
multiplied by this value. It should be between 0 and 1. Default is 0.55.}

\item{max_cr}{numeric. Maximum value of the crown diameter of a detected tree (in pixels).
Default is 10.}

\item{ID}{character. If the \code{SpatialPointsDataFrame} contains an attribute with the ID for
each tree, the name of this attribute. This way, original IDs will be preserved. If there is no
such data trees will be numbered sequentially.}
}
\description{
This function is made to be used in \link{lastrees}. It implements an algorithm for tree
segmentation based on the Dalponte and Coomes (2016) algorithm (see reference).
This is a seeds + growing region algorithm. This algorithm exists in the package \code{itcSegment}.
This version has been written from the paper in C++. Consequently it is hundreds to millions times
faster than the original version. Note that this algorithm strictly performs a segmentation, while the
original method as implemented in \code{itcSegment} and described in the manuscript also performs
pre- and post-processing tasks. Here these tasks are expected to be done by the user in separate functions.
}
\details{
Because this algorithm works on a CHM only there is no actual need for a point cloud. Sometimes the
user does not even have the point cloud that generated the CHM. \code{lidR} is a point cloud-oriented
library, which is why this algorithm must be used in \link{lastrees} to merge the result with the point
cloud. However the user can use this as a stand-alone function like this:
\preformatted{
 chm = raster("file/to/a/chm/")
 ttops = tree_detection(chm, lmf(3))
 crowns = dalponte2016(chm, ttops)()
}
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile, select = "xyz", filter = "-drop_z_below 0")
col <- pastel.colors(200)

chm <- grid_canopy(las, 0.5, p2r(0.3))
ker <- matrix(1,3,3)
chm <- raster::focal(chm, w = ker, fun = mean, na.rm = TRUE)

ttops <- tree_detection(chm, lmf(4, 2))
las   <- lastrees(las, dalponte2016(chm, ttops))
plot(las, color = "treeID", colorPalette = col)
}
\references{
Dalponte, M. and Coomes, D. A. (2016), Tree-centric mapping of forest carbon density from
airborne laser scanning and hyperspectral data. Methods Ecol Evol, 7: 1236–1245. doi:10.1111/2041-210X.12575.
}
\seealso{
Other individual tree segmentation algorithms: \code{\link{li2012}},
  \code{\link{silva2016}}, \code{\link{watershed}}

Other raster based tree segmentation algorithms: \code{\link{silva2016}},
  \code{\link{watershed}}
}
\concept{individual tree segmentation algorithms}
\concept{raster based tree segmentation algorithms}
