% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voxelize_points.R
\name{voxelize_points}
\alias{voxelize_points}
\title{Voxelize a point cloud}
\usage{
voxelize_points(las, res)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}

\item{res}{numeric. The resolution of the voxels. \code{res = 1} for a 1x1x1 cubic voxels. Optionally
\code{res = c(1,2)} for non-cubic voxels (1x1x2 cuboid voxel).}
}
\value{
If the input is a \code{LAS} object, returns a \code{LAS} object. If the input is a
\code{LAScatalog}, returns a \code{LAScatalog}.
}
\description{
Reduce the number of points by voxelizing the point cloud. If the Intensity is part of the attributes
it is preserved and aggregated as \code{mean(Intensity)}. Other attributes cannot be aggregated and
are lost.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile, select = "xyz")

las2 = voxelize_points(las, 5)
#plot(las2, voxel = TRUE)
}
