% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{lmaCheck}
\alias{lmaCheck}
\title{Checks linear model assumptions of a multiple regression model}
\usage{
lmaCheck(formule, df, max.pvalue = 0.05, max.vif = 5)
}
\arguments{
\item{formule}{formula. model to be evaluated}

\item{df}{data.frame. data to evaluate the model}

\item{max.pvalue}{numeric. maximum p-value of variables included in the model}

\item{max.vif}{numeric. maximum variance inflation factor of variables included in the model}
}
\value{
a one line data.frame with 5 columns.
\itemize{
\item a string: evaluated formula
\item a numeric: the adjusted R squared of the model
\item a boolean: do all variables in the model have a partial p-value < \code{max.pvalue}
\item a boolean: are all tests implemented by \code{\link[gvlma]{gvlma}} false
\item a boolean: is the variance inflation factor computed with \code{\link[car]{vif}} of all variables < \code{max.vif} 
}
}
\description{
The performed tests are:
\itemize{
\item partial p.values calculated by \code{\link[stats]{lm}} are all below a given value
\item tests implemented by \code{\link[gvlma]{gvlma}}
\item variance inflation factors calculated by \code{\link[car]{vif}} are all below a given value
}
}
\examples{
# load Quatre Montagnes dataset
data(quatremontagnes)
# fit lm model
model <- lm(G.m2.ha ~ zmax + zq95, data = quatremontagnes)
lmaCheck(eval(model$call[[2]]), quatremontagnes)
# trying with Box-Cox transformation of dependent variable  
# and other independent variables
model <- lm(BoxcoxTr(G.m2.ha, -0.14) ~ Tree.meanH + Tree.density + zpcum7 , data = quatremontagnes)
lmaCheck(eval(model$call[[2]]), quatremontagnes)
}
