% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_randomGenerationFunctions.R
\name{rmdt}
\alias{rmdt}
\title{Simulate from a multiple decrement table}
\usage{
rmdt(n = 1, object, x = 0, t = 1, t0 = "alive", include.t0 = TRUE)
}
\arguments{
\item{n}{Number of simulations.}

\item{object}{The \code{mdt} object to simulate from.}

\item{x}{the period to simulate from.}

\item{t}{the period until to simulate.}

\item{t0}{initial status (default is "alive").}

\item{include.t0}{should initial status to be included (default is TRUE)?}
}
\value{
A matrix with n columns (the length of simulation) and either t (if initial status 
is not included) or t+1 rows.
}
\description{
Simulate from a multiple decrement table
}
\section{Details}{

The functin uses \code{rmarkovchain} function from markovchain package to simulate the chain
}
\examples{
mdtDf<-data.frame(x=c(0,1,2,3),death=c(100,50,30,10),lapse=c(150,20,2,0))
myMdt<-new("mdt",name="example Mdt",table=mdtDf)
ciao<-rmdt(n=5,object = myMdt,x = 0,t = 4,include.t0=FALSE,t0="alive")

}
\author{
Giorgio Spedicato
}
\seealso{
\code{\link{rLifeContingenciesXyz}},\code{\link{rLifeContingencies}}
}

