% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotLift.R
\name{plotLift}
\alias{plotLift}
\title{Compute the top decile lift and plot the lift curve}
\usage{
plotLift(predicted, labels, cumulative = TRUE, n.buckets = 10, ...)
}
\arguments{
\item{predicted}{A numeric vector with the classifier's predicted scores / probabilities}

\item{labels}{An integer vector containing binary labels with values {0,1}}

\item{cumulative}{boolean. Should the cumulative lift curve be plotted or not?}

\item{n.buckets}{scalar. How many buckets should be used. One can use more buckets with large datasets}

\item{...}{additional parameters to the \code{plot} function}
}
\value{
lift curve
}
\description{
\code{plotLift} plots the commonly used lift curve by ordering the data by the predictions, and computing the proportion of positives for each bucket.
}
\examples{
data(churn)
plotLift(churn$predictions,churn$labels)
}
\author{
Steven Hoornaert, Michel Ballings, Dirk Van den Poel, Maintainer: \email{Steven.Hoornaert@UGent.be}
}

