% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.model.dt.tree.R
\name{lgb.model.dt.tree}
\alias{lgb.model.dt.tree}
\title{Parse a LightGBM model json dump}
\usage{
lgb.model.dt.tree(model, num_iteration = NULL, start_iteration = 1L)
}
\arguments{
\item{model}{object of class \code{lgb.Booster}.}

\item{num_iteration}{Number of iterations to include. NULL or <= 0 means use best iteration.}

\item{start_iteration}{Index (1-based) of the first boosting round to include in the output.
       For example, passing \code{start_iteration=5, num_iteration=3} for a regression model
       means "return information about the fifth, sixth, and seventh trees".

       \emph{New in version 4.4.0}}
}
\value{
A \code{data.table} with detailed information about model trees' nodes and leafs.

The columns of the \code{data.table} are:

\itemize{
 \item{\code{tree_index}: ID of a tree in a model (integer)}
 \item{\code{split_index}: ID of a node in a tree (integer)}
 \item{\code{split_feature}: for a node, it's a feature name (character);
                             for a leaf, it simply labels it as \code{"NA"}}
 \item{\code{node_parent}: ID of the parent node for current node (integer)}
 \item{\code{leaf_index}: ID of a leaf in a tree (integer)}
 \item{\code{leaf_parent}: ID of the parent node for current leaf (integer)}
 \item{\code{split_gain}: Split gain of a node}
 \item{\code{threshold}: Splitting threshold value of a node}
 \item{\code{decision_type}: Decision type of a node}
 \item{\code{default_left}: Determine how to handle NA value, TRUE -> Left, FALSE -> Right}
 \item{\code{internal_value}: Node value}
 \item{\code{internal_count}: The number of observation collected by a node}
 \item{\code{leaf_value}: Leaf value}
 \item{\code{leaf_count}: The number of observation collected by a leaf}
}
}
\description{
Parse a LightGBM model json dump into a \code{data.table} structure.
}
\examples{
\donttest{
\dontshow{setLGBMthreads(2L)}
\dontshow{data.table::setDTthreads(1L)}
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)

params <- list(
  objective = "binary"
  , learning_rate = 0.01
  , num_leaves = 63L
  , max_depth = -1L
  , min_data_in_leaf = 1L
  , min_sum_hessian_in_leaf = 1.0
  , num_threads = 2L
)
model <- lgb.train(params, dtrain, 10L)

tree_dt <- lgb.model.dt.tree(model)
}
}
