% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_jdx.R
\name{lr_parse_jdx}
\alias{lr_parse_jdx}
\title{Parse OceanInsight JCAMP-DX (.jdx) file}
\usage{
lr_parse_jdx(filename)
}
\arguments{
\item{filename}{Path of the file to parse}
}
\value{
A named list of two elements:
\itemize{
\item \code{data}: a dataframe with columns "wl", "dark", "white", "scope" and
"processed", in this order.
\item \code{metadata}: a character vector with metadata including:
\itemize{
\item \code{user}: Name of the spectrometer operator
\item \code{datetime}: Timestamp of the recording in format '\%Y-\%m-\%d \%H:\%M:\%S'
and UTC timezone. If timezone is missing in source file, UTC time will
be assumed (for reproducibility purposes across computers with different
localtimes).
\item \code{spec_model}: Model of the spectrometer
\item \code{spec_ID}: Unique ID of the spectrometer
\item \code{white_inttime}: Integration time of the white reference (in ms)
\item \code{dark_inttime}: Integration time of the dark reference (in ms)
\item \code{sample_inttime}: Integration time of the sample (in ms)
\item \code{white_avgs}: Number of averaged measurements for the white reference
\item \code{dark_avgs}: Number of averaged measurements for the dark reference
\item \code{sample_avgs}: Number of averaged measurements for the sample
\item \code{white_boxcar}: Boxcar width for the white reference
\item \code{dark_boxcar}: Boxcar width for the dark reference
\item \code{sample_boxcar}: Boxcar width for the sample reference
}
}
}
\description{
Parse OceanInsight (formerly OceanOptics) JCAMP-DX (.jdx) file.
\url{https://www.oceaninsight.com/}
}
\details{
'processed' column computed by \pkg{lightr} with the function
\code{\link[=lr_compute_processed]{lr_compute_processed()}}.
}
\examples{
lr_parse_jdx(system.file("testdata", "OceanOptics_period.jdx",
                         package = "lightr"))

}
\references{
McDonald RS, Wilks PA. JCAMP-DX: A Standard Form for Exchange of
Infrared Spectra in Computer Readable Form. Applied Spectroscopy.
1988;42(1):151-62.
}
