% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_apply_script_bits.R
\name{ls_apply_script_bits}
\alias{ls_apply_script_bits}
\title{Apply specific code bits from LimeSurvey data import R script}
\usage{
ls_apply_script_bits(
  data,
  scriptBits,
  setVarNames = TRUE,
  setLabels = TRUE,
  convertToCharacter = FALSE,
  convertToFactor = FALSE,
  categoricalQuestions = NULL,
  massConvertToNumeric = TRUE,
  silent = limonaid::opts$get("silent"),
  sticky = limonaid::opts$get("sticky")
)
}
\arguments{
\item{data}{The dataframe.}

\item{scriptBits}{The object returned by the call
to \code{\link[=ls_parse_data_import_script]{ls_parse_data_import_script()}}.}

\item{setVarNames, setLabels, convertToCharacter, convertToFactor}{Whether to
set variable names or labels, or convert to character or factor, using the
code isolated using the specified regular expression.}

\item{categoricalQuestions}{Which variables (specified using LimeSurvey
variable names) are considered categorical questions; for these, the script
to convert the variables to factors, as extracted from the LimeSurvey import
file, is applied.}

\item{massConvertToNumeric}{Whether to convert all variables to numeric
using \code{\link{massConvertToNumeric}}.}

\item{silent}{Whether to be silent or verbose ('chatty').}

\item{sticky}{Whether to make labels sticky (requires the {\code{sticky}}
package).}
}
\value{
The dataframe.
}
\description{
This function applies specific code bits from the LimeSurvey data
import R script, read by \code{\link[=ls_parse_data_import_script]{ls_parse_data_import_script()}}, for example
to update variable names, set labels, etc.
}
