% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_metrics.R
\name{event_gaps}
\alias{event_gaps}
\title{Event Gaps}
\usage{
event_gaps(e, closed = TRUE, range = NULL)
}
\arguments{
\item{e}{An event table.}

\item{closed}{Logical value indicating whether events should be interpreted as closed intervals. If \code{TRUE}, no gaps are returned at breaks between two adjacent events.}

\item{range}{An event table specifying, by its \code{\link{event_range}}, the interval within which to check for gaps. If \code{NULL}, the range of \code{e} is used.}
}
\description{
Returns the intervals over which there are no events.
}
\examples{
event_gaps(events(c(1, 3, 5), c(2, 4, 5)))    # gaps between events
event_gaps(events(1:5))                       # no gaps
event_gaps(events(1:5), closed = FALSE)       # gaps at breaks
event_gaps(events(1:5), range = events(0, 6)) # gaps to edge of range  
}
\seealso{
\code{\link{event_coverage}} for coverage (the inverse of gaps), \code{\link{fill_event_gaps}} for filling gaps with empty events.
}
