% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{stepwise2}
\alias{stepwise2}
\title{same as \code{step()} in R, but able to check marginal effects.}
\usage{
stepwise2(model, scope, trace = 1, steps = 1000, k = 2, data,
  family = NULL, IC_method = c("AIC", "BIC"), test_suit = NULL,
  STOP = FALSE)
}
\arguments{
\item{model}{an output of \code{lm} or \code{glm}}

\item{scope, trace, steps, k}{see \code{step()}}

\item{data}{a data.frame used in regression.}

\item{family}{used as the argument for \code{family} of \code{glm}, default is NULL, which means we will use the family imbedded in the model.}

\item{IC_method}{either 'AIC' or 'BIC', will overwrite the \code{k} argument above.}

\item{test_suit}{used to specify the correct marginal effect you want to check.
It is a list with names as raw variable and values as arguments of the function \code{deleting_wrongeffect}
If NULL (default), then not check any marginal effect
See example code for details.}

\item{STOP}{whether stop and wait your response for each step.}
}
\value{
a stepwise-selected model. If \code{test_suit} is specified, then the returned model is the one with highest AIC/BIC within those that get
correct marginal impact.

The silde effect is to print a data.frame containing diagnostic informations for each step. The 'correct_effect_ind' column is a boolean vector to show
whether the model has correct marginal effect or not.
}
\description{
same as \code{step()} in R, but able to check marginal effects.
}
\details{
For each step of regression, you can first choose the models with correct marginal effect
and then choose the one with highest AIC/BIC within them
}
\examples{

# starting model:
# can have a dirty formula like below

set.seed(413)
traing_data = ggplot2::diamonds[runif(nrow(ggplot2::diamonds))<0.05,]
nrow(traing_data)

diamond_lm3 = lm(formula = price ~ cut + carat - cut   , data = traing_data)

scope = list(lower = price ~ 1,
             upper = price ~  I(carat^2) + I(carat^3) + I(carat * depth) + depth + carat)

# traditional stepwise regression with no marginal effect check
model1 = stepwise2(model = diamond_lm3, scope = scope,k = 2,
                   trace = TRUE, data = traing_data, STOP = TRUE)
model1
# result is exactly same using the default step() function.
model2 = suppressWarnings(step(diamond_lm3,scope = scope, k = 2))
model2


#__ How to Specify the Correct Marginal Effects in Stepwise Regression  __

# this test_suit means we will check the marginal effect of both 'carat' and 'depth'
# for 'carat', we will only focus on 4 coeff vars :
    # "I(carat^3)","I(carat*depth)","I(carat^2)","carat"
# for 'depth', as we do not specify any particular coeff vars there,
# we will check all coeff var related to 'depth'

test_suit = list(
  carat = list(
    # the list name must be the raw var
    focus_var_raw = "carat",
    # must specify the focus_var_raw (see deleting_wrongeffect() ) as the raw var
    focus_var_coeff = c("I(carat^3)","I(carat*depth)",
                        "I(carat^2)","carat") ,
    # optional # If not defined, then we to check all coeffs related to the raw var
    focus_value =list(carat = seq(0.5,6,0.1)),
    Monoton_to_Match = 1 # optional. Default is 1
  ),
  depth = list(
    focus_var_raw = "depth",
    Monoton_to_Match = 1
  )
)

model3 =  stepwise2(model = diamond_lm3, scope = scope, trace = TRUE,
                    data = traing_data,
                    STOP = FALSE, test_suit = test_suit)

# see the difference from model1
effect(model3,focus_var_raw =  "carat", focus_value =list(carat = seq(0.5,6,0.1)))

}

