% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wals.feature.R
\name{wals.feature}
\alias{wals.feature}
\title{Download WALS data}
\usage{
wals.feature(features, na.rm = TRUE, glottolog.source = "modified")
}
\arguments{
\item{features}{A character vector that define with a feature ids from WALS (e. g. "1a", "21b").}

\item{na.rm}{Logical. If TRUE function removes all languages not available in lingtypology database. By default is TRUE.}

\item{glottolog.source}{A character vector that define which glottolog database is used: 'original' or 'modified' (by default)}
}
\description{
This function downloads data from WALS (http://wals.info) and changes language names to the names from lingtypology database. You need the internet connection.
}
\examples{
# wals.feature(c("1a", "20a"))
}
\seealso{
\code{\link{abvd.feature}}, \code{\link{afbo.feature}}, \code{\link{autotyp.feature}}, \code{\link{oto_mangueanIC.feature}}, \code{\link{phoible.feature}}, \code{\link{sails.feature}}, \code{\link{uralex.feature}}, \code{\link{valpal.feature}}
}
\author{
George Moroz <agricolamz@gmail.com>
}
