% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usefulStuff.R
\name{sf2gvec}
\alias{sf2gvec}
\title{Write sf object to GRASS 7 vector utilising an existing or creating a new GRASS7 environment}
\usage{
sf2gvec(x, obj_name, gisdbase, location, gisdbase_exist = FALSE)
}
\arguments{
\item{x}{\code{\link{sf}} object corresponding to the settings of the corresponding GRASS container}

\item{obj_name}{name of GRASS layer}

\item{gisdbase}{GRASS gisDbase folder}

\item{location}{GRASS location name containing \code{obj_name)}}

\item{gisdbase_exist}{logical switch if the GRASS gisdbase folder exist default is TRUE}
}
\description{
Write sf object to GRASS 7 vector utilising an existing or creating a new GRASS7 environment
}
\note{
have a look at the \code{\link{sf}} capabilities to write direct to sqlite
}
\examples{
\dontrun{
## example 
# get meuse data as sf object
require(sf)
require(sp)
data(meuse)
meuse_sf = st_as_sf(meuse, 
                   coords = c("x", "y"), 
                   crs = 28992, 
                   agr = "constant")
    
# write data to GRASS and create gisdbase
sf2gvec(x = meuse_sf,
          obj_name = "meuse_R-G",
          gisdbase = "~/temp3",
          location = "project1")
 
# read from existing GRASS          
gvec2sf(x = meuse_sf,
          obj_name = "meuse_R-G",
          gisdbase = "~/temp3",
          location = "project1")
}
}
\author{
Chris Reudenbach
}
