% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spa.R
\name{sparse_project}
\alias{sparse_project}
\title{Successive projections with sparsely defined restrictions}
\usage{
sparse_project(
  x,
  A,
  b,
  neq = length(b),
  w = rep(1, length(x)),
  eps = 0.01,
  maxiter = 1000L,
  ...
)
}
\arguments{
\item{x}{\code{[numeric]} Vector to optimize, starting point.}

\item{A}{\code{[data.frame]} Coeffiencient matrix in \code{[row,column,coefficient]} format.}

\item{b}{\code{[numeric]} Constant vector of the system \eqn{Ax\leq b}}

\item{neq}{\code{[integer]} Number of equalities}

\item{w}{\code{[numeric]} weight vector of same length of \code{x}}

\item{eps}{maximally allowed tolerance}

\item{maxiter}{maximally allowed number of iterations.}

\item{...}{extra parameters passed to \code{\link{sparse_constraints}}}
}
\value{
A \code{list} with the following entries:
\itemize{
 \item{\code{x}: the adjusted vector}
 \item{\code{status}: Exit status:
  \itemize{
   \item{0: success}
   \item{1: could not allocate enough memory (space for approximately \eqn{2(m+n)} \code{double}s is necessary).}
   \item{2: divergence detected (set of restrictions may be contradictory)}
   \item{3: maximum number of iterations reached}
  }
 }
 \item{\code{eps}: The tolerance achieved after optimizing (see Details).}
 \item{\code{iterations}: The number of iterations performed.}
 \item{\code{duration}: the time it took to compute the adjusted vector}
 \item{\code{objective}: The (weighted) Euclidean distance between the initial and the adjusted vector}
}
}
\description{
Compute a vector, closest to \eqn{x} satisfying a set of linear (in)equality restrictions.
}
\section{Details}{


The tolerance \code{eps} is defined as the maximum absolute value of the difference vector 
\eqn{\boldsymbol{Ax}-\boldsymbol{b}} for equalities. For inequalities, the difference vector
is set to zero when it's value is lesser than zero (i.e. when the restriction is satisfied). The
algorithm iterates until either the tolerance is met, the number of allowed iterations is
exceeded or divergence is detected.
}

\examples{

# the system 
# x + y = 10
# -x <= 0   # ==> x > 0
# -y <= 0   # ==> y > 0
# Defined in the row-column-coefficient form:

A <- data.frame(
    row = c(1,1,2,3)
  , col = c(1,2,1,2)
  , coef= c(1,1,-1,-1)
)
b <- c(10,0,0)

sparse_project(x=c(4,5),A=A,b=b)

}
\seealso{
\code{\link{project}}, \code{\link{sparse_constraints}}
}
