% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absolute_path_linter.R
\name{absolute_path_linter}
\alias{absolute_path_linter}
\title{Absolute path linter}
\usage{
absolute_path_linter(lax = TRUE)
}
\arguments{
\item{lax}{Less stringent linting, leading to fewer false positives.
If \code{TRUE}, only lint path strings, which
\itemize{
\item contain at least two path elements, with one having at least two characters and
\item contain only alphanumeric chars (including UTF-8), spaces, and win32-allowed punctuation
}}
}
\description{
Check that no absolute paths are used (e.g. "/var", "C:\\System", "~/docs").
}
\examples{
# will produce lints
lint(
  text = 'R"--[/blah/file.txt]--"',
  linters = absolute_path_linter()
)

# okay
lint(
  text = 'R"(./blah)"',
  linters = absolute_path_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \code{\link[=nonportable_path_linter]{nonportable_path_linter()}}
}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=robustness_linters]{robustness}
}
