% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_name_linter.R
\name{object_name_linter}
\alias{object_name_linter}
\title{Object name linter}
\usage{
object_name_linter(styles = c("snake_case", "symbols"), regexes = character())
}
\arguments{
\item{styles}{A subset of
\Sexpr[stage=render, results=rd]{lintr:::regexes_rd}. A name should
match at least one of these styles. The \code{"symbols"} style refers to
names containing \emph{only} non-alphanumeric characters; e.g., defining \verb{\%+\%}
from ggplot2 or \verb{\%>\%} from magrittr would not generate lint markers,
whereas \verb{\%m+\%} from lubridate (containing both alphanumeric \emph{and}
non-alphanumeric characters) would.}

\item{regexes}{A (possibly named) character vector specifying a custom naming convention.
If named, the names will be used in the lint message. Otherwise, the regexes enclosed by \code{/} will be used in the
lint message.
Note that specifying \code{regexes} overrides the default \code{styles}. So if you want to combine \code{regexes} and \code{styles},
both need to be explicitly specified.}
}
\description{
Check that object names conform to a naming style.
The default naming styles are "snake_case" and "symbols".
}
\details{
Quotes (\verb{`"'}) and specials (\verb{\%} and trailing \verb{<-}) are not considered part of the object name.

Note when used in a package, in order to ignore objects imported
from other namespaces, this linter will attempt \code{\link[=getNamespaceExports]{getNamespaceExports()}}
whenever an \code{import(PKG)} or \code{importFrom(PKG, ...)} statement is found
in your NAMESPACE file. If \code{\link[=requireNamespace]{requireNamespace()}} fails (e.g., the package
is not yet installed), the linter won't be able to ignore some usages
that would otherwise be allowed.

Suppose, for example, you have \code{import(upstream)} in your NAMESPACE,
which makes available its exported S3 generic function
\code{a_really_quite_long_function_name} that you then extend in your package
by defining a corresponding method for your class \code{my_class}.
Then, if \code{upstream} is not installed when this linter runs, a lint
will be thrown on this object (even though you don't "own" its full name).

The best way to get lintr to work correctly is to install the package so
that it's available in the session where this linter is running.
}
\examples{
# will produce lints
lint(
  text = "my_var <- 1L",
  linters = object_name_linter(styles = "CamelCase")
)

lint(
  text = "xYz <- 1L",
  linters = object_name_linter(styles = c("UPPERCASE", "lowercase"))
)

lint(
  text = "MyVar <- 1L",
  linters = object_name_linter(styles = "dotted.case")
)

lint(
  text = "asd <- 1L",
  linters = object_name_linter(regexes = c(my_style = "F$", "f$"))
)

# okay
lint(
  text = "my_var <- 1L",
  linters = object_name_linter(styles = "snake_case")
)

lint(
  text = "xyz <- 1L",
  linters = object_name_linter(styles = "lowercase")
)

lint(
  text = "my.var <- 1L; myvar <- 2L",
  linters = object_name_linter(styles = c("dotted.case", "lowercase"))
)

lint(
  text = "asdf <- 1L; asdF <- 1L",
  linters = object_name_linter(regexes = c(my_style = "F$", "f$"))
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=consistency_linters]{consistency}, \link[=default_linters]{default}, \link[=executing_linters]{executing}, \link[=style_linters]{style}
}
