% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liquidSVM.R
\docType{package}
\name{liquidSVM-package}
\alias{liquidSVM-package}
\alias{liquidSVM}
\title{liquidSVM for R}
\description{
Support vector machines (SVMs) and related kernel-based learning algorithms are a well-known
class of machine learning algorithms, for non-parametric classification and regression.
\pkg{liquidSVM} is an implementation of SVMs whose key features are:
\itemize{
\item fully integrated hyper-parameter selection,
\item extreme speed on both small and large data sets,
\item full flexibility for experts, and
\item inclusion of a variety of different learning scenarios:
\itemize{
\item multi-class classification, ROC, and Neyman-Pearson learning, and
\item least-squares, quantile, and expectile regression
}
}
\ifelse{latex}{\out{\clearpage}}{}
Further information is available in the following vignettes:
\tabular{ll}{
\code{demo} \tab liquidSVM Demo (source, pdf)
\cr\code{documentation} \tab liquidSVM Documentation (source, pdf)\cr
}
}
\details{
In \pkg{liquidSVM} an application cycle is divided into a training phase, in which various SVM
models are created and validated, a selection phase, in which the SVM models that best
satisfy a certain criterion are selected, and a test phase, in which the selected models are
applied to test data. These three phases are based upon several components, which can be
freely combined using different components: solvers, hyper-parameter selection, working sets.
All of these can be configured (see \link{Configuration}) a

For instance multi-class classification with \eqn{k} labels has to be delegated to several binary classifications
called \emph{tasks} either using all-vs-all (\eqn{k(k-1)/2} tasks on the corresponding subsets) or
one-vs-all (\eqn{k} tasks on the full data set).
Every task can be split into \emph{cells} in order to handle larger data sets (for example \eqn{>10000} samples).
Now for every task and every cell, several \emph{folds} are created to enable cross-validated hyper-parameter selection.

The following learning scenarios can be used out of the box:
\describe{
\item{\code{\link{mcSVM}}}{binary and multi-class classification}
\item{\code{\link{lsSVM}}}{least squares regression}
\item{\code{\link{nplSVM}}}{Neyman-Pearson learning to classify with a specified rate on one type of error}
\item{\code{\link{rocSVM}}}{Receivert Operating Characteristic (ROC) curve to solve multiple weighted binary classification problems.}
\item{\code{\link{qtSVM}}}{quantile regression}
\item{\code{\link{exSVM}}}{expectile regression}
\item{\code{\link{bsSVM}}}{bootstrapping}
}

To calculate kernel matrices as used by the SVM we also provide for convenience the function
\code{\link{kern}}.

\pkg{liquidSVM} can benefit heavily from native compilation, hence we recommend to (re-)install it
using the information provided in the \href{../doc/documentation.html#Installation}{installation section}
of the documentation vignette.
}
\section{Known issues}{


Interruption (Ctrl-C) of running train/select/test phases is honored, but can leave
the C++ library in an inconsistent state, so that it is better to save your work and restart your
\R session.

\pkg{liquidSVM} is multi-threaded and is difficult to be multi-threaded externally, see
\href{../doc/documentation.html#Using external parallelization}{documentation}
}

\examples{
\dontrun{
set.seed(123)
## Multiclass classification
modelIris <- svm(Species ~ ., iris)
y <- predict(modelIris, iris)

## Least Squares
modelTrees <- svm(Height ~ Girth + Volume, trees)
y <- predict(modelTrees, trees)
plot(trees$Height, y)
test(modelTrees, trees)

## Quantile regression
modelTrees <- qtSVM(Height ~ Girth + Volume, trees, scale=TRUE)
y <- predict(modelTrees, trees)

## ROC curve
modelWarpbreaks <- rocSVM(wool ~ ., warpbreaks, scale=TRUE)
y <- test(modelWarpbreaks, warpbreaks)
plotROC(y,warpbreaks$wool)
}
}
\references{
\url{http://www.isa.uni-stuttgart.de}
}
\seealso{
\code{\link{init.liquidSVM}}, \code{\link{trainSVMs}}, \code{\link{predict.liquidSVM}}, \code{\link{clean.liquidSVM}}, and \code{\link{test.liquidSVM}}, \link{Configuration};
}
\author{
Ingo Steinwart \email{ingo.steinwart@mathematik.uni-stuttgart.de},
Philipp Thomann \email{philipp.thomann@mathematik.uni-stuttgart.de}

Maintainer: Philipp Thomann \email{philipp.thomann@mathematik.uni-stuttgart.de}
}
\keyword{SVM}
