<!-- README.md is generated from README.Rmd. Please edit that file -->

# **liver** <a href='https://CRAN.R-project.org/package=liver'><img src='man/figures/logo.png' align="right" height="300" /></a>

![](https://www.r-pkg.org/badges/version/liver) 
![](https://www.r-pkg.org/badges/last-release/liver) 
![](https://cranlogs.r-pkg.org/badges/liver) 
![](https://cranlogs.r-pkg.org/badges/grand-total/liver) 

The `R` package **liver** offers a suite of helper functions to simplify various data science techniques for non-experts. This package aims to enable individuals with only a minimal level of coding knowledge to become acquainted with these techniques in an accessible manner. Inspired by an ancient Persian idiom, we liken this process to "eating the liver of data science," suggesting a deep and intimate engagement with the field of data science. This package includes functions for tasks such as data partitioning for out-of-sample testing, calculating Mean Squared Error (MSE) to assess prediction accuracy, and data transformations (z-score and min-max). In addition to these helper functions, the 'liver' package also features several intriguing datasets valuable for multivariate analysis.

## Installation

To install the latest version of this package from [CRAN](https://cran.r-project.org/package=liver), do the following from the R console:

``` r
install.packages( "liver" )
```

## Loading

``` r
library( liver )
```

## Example for Data Analysis

To see how to use the functionality of the package for data analysis:

[https://CRAN.R-project.org/package=liver/vignettes/liver-example.html](https://CRAN.R-project.org/package=liver/vignettes/liver-example.html)

