% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoreg_forc.R
\name{autoreg_forc}
\alias{autoreg_forc}
\title{Autoregression forecast}
\usage{
autoreg_forc(
  realized_vec,
  h_ahead,
  estimation_end,
  time_vec = NULL,
  estimation_window = NULL
)
}
\arguments{
\item{realized_vec}{Vector of realized values. This is the series that is
being forecasted.}

\item{h_ahead}{Integer representing the number of periods ahead that is being
forecasted.}

\item{estimation_end}{Value of any class representing when to end the initial
coefficient estimation period and begin forecasting.}

\item{time_vec}{Vector of any class that is equal in length to the
\code{realized_vec} vector.}

\item{estimation_window}{Integer representing the number of past periods
that the autoregressive model should be estimated over in each period.}
}
\value{
\code{\link{Forecast}} object that contains the autoregression
forecast.
}
\description{
\code{autoreg_forc} takes a vector of realized values, an integer number of
periods ahead to forecast, a period to end the initial model estimation and
begin forecasting, an optional vector of time data associated with the
realized values, and an optional integer number of past periods to estimate
the model over. An AR(\code{h_ahead}) autoregressive model is estimated with realized
values up to \code{estimation_end} minus the number of periods specified in
\code{estimation_window}. If \code{estimation_window} is left \code{NULL}
then the autoregressive model is estimated with all realized values up to
\code{estimation_end}. The AR(\code{h_ahead}) model is estimated by regressing the
realized values on the same realized values that have been lagged by
\code{h_ahead} steps. The AR coefficient of this model is multiplied by the
present period realized value to create a forecast for \code{h_ahead} periods
ahead. This process is iteratively repeated for each period after
\code{estimation_end} with AR model coefficients updating as more information
would have become available to the forecaster. Returns an autoregression
forecast based on information that \strong{would} have been available at the
forecast origin.
}
\examples{
date <- as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31",
                  "2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31", 
                  "2012-03-31", "2012-06-30"))
y  <- c(1.09, 1.71, 1.09, 2.46, 1.78, 1.35, 2.89, 2.11, 2.97, 0.99)
data <- data.frame(date, y)

autoreg_forc(
  realized_vec = data$y,
  h_ahead = 2L,
  estimation_end = as.Date("2011-06-30"),
  time_vec = data$date,
  estimation_window = NULL
)

autoreg_forc(
  realized_vec = data$y,
  h_ahead = 2L,
  estimation_end = 4L
)

}
\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
