% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast.R
\name{h_ahead<-,Forecast-method}
\alias{h_ahead<-,Forecast-method}
\title{Set h_ahead slot of a Forecast object}
\usage{
\S4method{h_ahead}{Forecast}(Forecast) <- value
}
\arguments{
\item{Forecast}{Forecast object.}

\item{value}{Vector of values assigned to the h_ahead slot of the Forecast.}
}
\value{
\code{\link{Forecast}} object that contains the new h_ahead vector.
}
\description{
\code{h_ahead} takes a \code{\link{Forecast}} object and sets the h_ahead
vector of the forecast.
}
\examples{
my_forecast <- Forecast(
   origin   = c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31"),
   future   = c("2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31"),
   forecast = c(4.21, 4.27, 5.32, 5.11),
   realized = c(4.40, 4.45, 4.87, 4.77),
   h_ahead  = 2L
)

h_ahead(my_forecast) <- 4L

}
