\name{DT_cornhybrids}
\alias{DT_cornhybrids}
\alias{DTi_cornhybrids}
\alias{GT_cornhybrids}
\docType{data}
\title{
Corn crosses and markers
}
\description{
This dataset contains phenotpic data for plant height and grain yield for 100 out of 400 possible hybrids originated from 40 inbred lines belonging to 2 heterotic groups, 20 lines in each, 1600 rows exist for the 400 possible hybrids evaluated in 4 locations but only 100 crosses have phenotypic information.  The purpose of this data is to show how to predict the other 300 crosses.

The data contains 3 elements. The first is the phenotypic data and the parent information for each cross evaluated in the 4 locations. 1200 rows should have missing data but the 100 crosses performed were chosen to be able to estimate the GCA and SCA effects of everything.

The second element of the data set is the phenotypic data and other relevant information for the 40.

The third element is the genomic relationship matrix for the 40 inbred lines originated from 511 SNP markers and calculated using the A.mat function.

}
\usage{data("DT_cornhybrids")}
\format{
  The format is:
 chr "DT_cornhybrids"
}
\source{
This data was generated by a corn study.
}
\references{

Giovanny Covarrubias-Pazaran (2024).  lme4breeding: enabling genetic evaluation in the age of genomic data. To be submitted to Bioinformatics.

Douglas Bates, Martin Maechler, Ben Bolker, Steve Walker (2015). Fitting Linear Mixed-Effects Models Using lme4. Journal of Statistical Software, 67(1), 1-48.

}
\examples{

data(DT_cornhybrids)
DT <- DT_cornhybrids
GT <- GT_cornhybrids
A <- GT
K1 <- A[levels(DT$GCA1), levels(DT$GCA1)]; dim(K1)
K2 <- A[levels(DT$GCA2), levels(DT$GCA2)]; dim(K2)

\donttest{
S <- kronecker(K1, K2) ; dim(S)
rownames(S) <- colnames(S) <- levels(DT$SCA)

ans <- lmebreed(Yield ~ Location + (1| GCA1) + (1|GCA2),
                relmat = list(GCA1=K1,
                              GCA2=K2),
                # how to control n iterations
                 # control = lmerControl( 
                 #  optCtrl = list(maxfun = 100, maxeval = 100)
                 #   ),
                data=DT)
vc <- VarCorr(ans); print(vc,comp=c("Variance"))
sigma(ans)^2 # error variance
BLUP <- ranef(ans, condVar=TRUE)
SEs <- attr(BLUP$GCA1, which="postVar")[,,]

}


}
\keyword{datasets}
\seealso{The core function of the package \code{\link{lmebreed}} }
