% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-support.R
\name{LMK_colramp}
\alias{LMK_colramp}
\title{Color Ramp}
\usage{
LMK_colramp(grp, mute = TRUE)
}
\arguments{
\item{grp}{A grouping variable, should be a factor}

\item{mute}{Logical, should color be muted. If true (default), color values will be generated with saturation value of .4, if false, values will have full saturation (1.0)}
}
\value{
Returns a vector of color assignments for each individual based on a grouping factor.
}
\description{
Create a color ramp based on a grouping factor
}
\details{
Creates color ramp for a given factor and returns a vector of color assignments for each individual using grDevices::rainbow(). Useful for plotting by group.
}
\examples{

data <- cbind(1:20, 20:1)
grps <- as.factor(rep(c("A","B","C","D","E"),4)) 
plot(data, col = LMK_colramp(grps), pch = 16) ##convert factor to rainbow pallete
}
\author{
Daniel Ehrlich
}
