\name{pwm.pp}
\alias{pwm.pp}
\title{ Plotting Position Probability-Weighted Moments }
\description{
Plotting position Probability-Weighted Moments (PWMs) are computed from
a sample. The first five \eqn{\beta_r}'s are computed. The plotting position
formula is

\deqn{p_i = \frac{i+A}{n+B}}

where \eqn{pp_i} is the nonexceedance probability \eqn{F} of the \eqn{i}th ascending
data values.  The parameters \eqn{A} and \eqn{B} together specify the plotting
position type, and \eqn{n} is the sample size. The PWMs are computed by

\deqn{\beta_r = n^{-1}\sum_{i=1}^{n}p_i^r \times X_{j:n}}

where \eqn{X_{j:n}} is the \eqn{j}th order statistic
\eqn{X_{1:n} \le X_{2:n} \le X_{j:n} \dots \le X_{n:n}} of random variable X, and
\eqn{r} is \eqn{0, 1, 2, \dots}.
}
\usage{
pwm.pp(x,A,B)
}
\arguments{
  \item{x}{A vector of data values.}
  \item{A}{A value for the plotting position formula.}
  \item{B}{Another value for the plotting position formula.}
}  
\value{
  An R \code{list} is returned.

  \item{BETA0}{The first PWM--equal to the arithmetic mean.}
  \item{BETA1}{The second PWM.}
  \item{BETA2}{The third PWM.}
  \item{BETA3}{The fourth PWM.}
  \item{BETA4}{The fifth PWM.}
}
\references{
Greenwood, J.A., Landwehr, J.M., Matalas, N.C., and Wallis, J.R., 1979,
Probability weighted moments--Definition and relation to parameters of
several distributions expressable in inverse form: Water Resources Research,
vol. 15, p. 1,049-1,054.

Hosking, J.R.M., 1990, L-moments--Analysis and estimation of
distributions using linear combinations of order statistics: Journal
of the Royal Statistical Society, Series B, vol. 52, p. 105-124.

Hosking, J.R.M., 1996, FORTRAN routines for use with the method of L-moments:
Version 3, IBM Research Report RC20525, T.J. Watson Research Center,
Yorktown Heights, New York.

Hosking, J.R.M. and Wallis, J.R., 1997, Regional frequency analysis--An
approach based on L-moments: Cambridge University Press.
}
\author{ W.H. Asquith}
\seealso{ \code{\link{pwm.ub}}, \code{\link{pwm.gev}}, \code{\link{pwm2lmom}} }
\examples{
pwm <- pwm.pp(rnorm(20),A=-0.35,B=0)
}
\keyword{univar}
\keyword{distribution}
