% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.lmvar.R
\name{coef.lmvar}
\alias{coef.lmvar}
\title{Extracts coefficients from an 'lmvar' object.}
\usage{
\method{coef}{lmvar}(object, mu = TRUE, sigma = TRUE, ...)
}
\arguments{
\item{object}{Object of class 'lmvar'}

\item{mu}{Boolean, specifies whether or not to return the maximum-likelihood estimator for \eqn{\beta_\mu}}

\item{sigma}{Boolean, specifies whether or not to return the maximum-likelihood estimator for \eqn{\beta_\sigma}}

\item{...}{For compatibility with \code{\link[stats]{coef}} generic}
}
\value{
When \code{mu = TRUE} and \code{sigma = TRUE}, a named numeric vector with the elements of \eqn{\beta_\mu},
followed by the elements of \eqn{\beta_\sigma}.

When \code{mu = TRUE} and \code{sigma = FALSE}, a named numeric vector with the elements of \eqn{\beta_\mu}.

When \code{mu = FALSE} and \code{sigma = TRUE}, a named numeric vector with the elements of \eqn{\beta_\sigma}.
}
\description{
Extracts maximum-likelihood estimators for \eqn{\beta_\mu} and \eqn{\beta_\sigma} from an 'lmvar' object.
}
\details{
When both \code{mu = TRUE} and \code{sigma = TRUE}, the names of the
coefficients in \eqn{\beta_\sigma} are adapted to distinguish them from the names in \eqn{\beta_\mu}, if needed.
}
\examples{
# As example we use the dataset 'attenu' from the library 'datasets'. The dataset contains
# the response variable 'accel' and two explanatory variables 'mag'  and 'dist'.
library(datasets)

# Create the model matrix for the expected values
X = cbind(attenu$mag, attenu$dist, attenu$mag + attenu$dist)
colnames(X) = c("mag", "dist", "mag+dist")

# Create the model matrix for the standard deviations.
X_s = cbind(attenu$mag, 1 / attenu$dist)
colnames(X_s) = c("mag", "dist_inv")

# Carry out the fit
fit = lmvar(attenu$accel, X, X_s)

# Extract all coefficients
coef(fit)

# Extract only the coefficients corresponding to the (non-aliased)
# columns in the model matrix for the expected values
coef(fit, sigma = FALSE)

# Extract only the coefficients corresponding to the (non-aliased)
# columns in the model matrix for standard deviations
coef(fit, mu = FALSE)
}
\seealso{
\code{\link{beta_sigma_names}} for the adaptation of the names of the coefficients in \eqn{\beta_\sigma}.

\code{\link[stats]{confint}} for the calculation of confidence intervals of \eqn{\beta_\mu} and \eqn{\beta_\sigma}.
}
