% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localStrat.r
\name{sMatrix}
\alias{sMatrix}
\title{Cpp implementation of the s-matrix function (which computes the weighted Jaccard similarity matrix) for a (sparse) input matrix as in the 'Stego' package on https://github.com/dschlauch/stego.}
\usage{
sMatrix(m, dense = FALSE, phased = FALSE, minVariants = 0)
}
\arguments{
\item{m}{A (sparse) matrix for which the s-matrix is sought. The input matrix is assumed to be oriented to contain the data for one individual per column.}

\item{dense}{Flag to switch between purpose-built dense or sparse implementations. Default is \code{dense=FALSE}.}

\item{phased}{Boolean flag to indicate if input matrix is phased. Default is \code{phased=FALSE}.}

\item{minVariants}{Integer cutoff value for minimal number of variants. Default is \code{minVariants=0}}
}
\value{
The s-matrix (the weighted Jaccard matrix) of \code{m}.
}
\description{
Cpp implementation of the s-matrix function (which computes the weighted Jaccard similarity matrix) for a (sparse) input matrix as in the 'Stego' package on https://github.com/dschlauch/stego.
}
\examples{
library(locStra)
library(Matrix)
m <- matrix(sample(0:1,15,replace=TRUE),ncol=3)
sparseM <- Matrix(m,sparse=TRUE)
print(sMatrix(sparseM))

}
\references{
Daniel Schlauch (2016). Implementation of the stego algorithm - Similarity Test for Estimating Genetic Outliers. https://github.com/dschlauch/stego
}
