% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{localScoreC}
\alias{localScoreC}
\title{Local score}
\usage{
localScoreC(v, supressWarnings = FALSE)
}
\arguments{
\item{v}{: a sequence of integer values as vector.}

\item{supressWarnings}{: if warnings should not be displayed}
}
\value{
A structure containing: the local score value and the begin and end index of the segment realizing this optimal score ; all the local maxima of the Lindley process (non negative excursion) and their begin and ens index ; the record times of the Lindley process but only the ones corresponding to the begin index of non negative excursions
}
\description{
Calculates the local score for a sequence of integer scores. Only provides the
first occurrence of the local score. Use function suboptimalSegment() or Lindley() to obtain the others localizations of the different realizations of the local score.
}
\examples{
seq.OneSegment=c(1,-2,3,1,-1,2)
# one segment realizing the local score value
localScoreC(seq.OneSegment) 
seq.TwoSegments=c(1,-2,3,1,2,-2,-2,-1,1,-2,3,1,2,-1,-2,-2,-1,1)
# two segments realizing the local score value
localScoreC(seq.TwoSegments) 
# only the first realization
localScoreC(seq.TwoSegments)$localScore 
# all the realization of the local together with the suboptimal ones
localScoreC(seq.TwoSegments)$suboptimalSegmentScores 
# for small sequences, you can also use lindley() fonction to check if 
# several segments achieve the local Score
lindley(seq.TwoSegments) 
plot(1:length(seq.TwoSegments),lindley(seq.TwoSegments),type='b')
seq.TwoSegments.InSameExcursion=c(1,-2,3,2,-1,0,1,-2,-2,-4,1)
localScoreC(seq.TwoSegments.InSameExcursion)
# lindley() shows two realizations in the same excursion (no 0 value between the two LS values)
lindley(seq.TwoSegments.InSameExcursion) 
# same beginning index but two possible ending indexes
# only one excursion realizes the local score even in there is two possible length of segment
localScoreC(seq.TwoSegments.InSameExcursion)$suboptimalSegmentScores 
plot(1:length(seq.TwoSegments.InSameExcursion),lindley(seq.TwoSegments.InSameExcursion),type='b')
}
